/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.unix.UnixBaseboard;
import oshi.hardware.platform.unix.solaris.SolarisFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;

@Immutable
final class SolarisComputerSystem
extends AbstractComputerSystem {
    private final Supplier<SmbiosStrings> smbiosStrings = Memoizer.memoize(SolarisComputerSystem::readSmbios);

    SolarisComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        return this.smbiosStrings.get().manufacturer;
    }

    @Override
    public String getModel() {
        return this.smbiosStrings.get().model;
    }

    @Override
    public String getSerialNumber() {
        return this.smbiosStrings.get().serialNumber;
    }

    @Override
    public String getHardwareUUID() {
        return this.smbiosStrings.get().uuid;
    }

    @Override
    public Firmware createFirmware() {
        return new SolarisFirmware(this.smbiosStrings.get().biosVendor, this.smbiosStrings.get().biosVersion, this.smbiosStrings.get().biosDate);
    }

    @Override
    public Baseboard createBaseboard() {
        return new UnixBaseboard(this.smbiosStrings.get().boardManufacturer, this.smbiosStrings.get().boardModel, this.smbiosStrings.get().boardSerialNumber, this.smbiosStrings.get().boardVersion);
    }

    private static SmbiosStrings readSmbios() {
        Object object;
        String string = "Serial Number";
        SmbType smbType = null;
        EnumMap enumMap = new EnumMap(SmbType.class);
        enumMap.put(SmbType.SMB_TYPE_BIOS, new HashMap());
        enumMap.put(SmbType.SMB_TYPE_SYSTEM, new HashMap());
        enumMap.put(SmbType.SMB_TYPE_BASEBOARD, new HashMap());
        for (String object22 : ExecutingCommand.runNative("smbios")) {
            if (object22.contains("SMB_TYPE_") && (smbType = SolarisComputerSystem.getSmbType(object22)) == null) break;
            object = object22.indexOf(":");
            if (smbType == null || (Integer)object < 0) continue;
            String string2 = object22.substring(0, (Integer)object).trim();
            String string3 = object22.substring((Integer)object + 1).trim();
            ((Map)enumMap.get((Object)smbType)).put(string2, string3);
        }
        Map map = (Map)enumMap.get((Object)SmbType.SMB_TYPE_BIOS);
        Map map2 = (Map)enumMap.get((Object)SmbType.SMB_TYPE_SYSTEM);
        object = (Map)enumMap.get((Object)SmbType.SMB_TYPE_BASEBOARD);
        if (!map2.containsKey("Serial Number") || Util.isBlank((String)map2.get("Serial Number"))) {
            map2.put("Serial Number", SolarisComputerSystem.readSerialNumber());
        }
        return new SmbiosStrings(map, map2, (Map)object);
    }

    private static SmbType getSmbType(String string) {
        for (SmbType smbType : SmbType.values()) {
            if (!string.contains(smbType.name())) continue;
            return smbType;
        }
        return null;
    }

    private static String readSerialNumber() {
        String string = ExecutingCommand.getFirstAnswer("sneep");
        if (string.isEmpty()) {
            String string2 = "chassis-sn:";
            for (String string3 : ExecutingCommand.runNative("prtconf -pv")) {
                if (!string3.contains(string2)) continue;
                string = ParseUtil.getSingleQuoteStringValue(string3);
                break;
            }
        }
        return string;
    }

    private static final class SmbiosStrings {
        private final String biosVendor;
        private final String biosVersion;
        private final String biosDate;
        private final String manufacturer;
        private final String model;
        private final String serialNumber;
        private final String uuid;
        private final String boardManufacturer;
        private final String boardModel;
        private final String boardVersion;
        private final String boardSerialNumber;

        private SmbiosStrings(Map<String, String> map, Map<String, String> map2, Map<String, String> map3) {
            String string = "Vendor";
            String string2 = "Release Date";
            String string3 = "Version String";
            String string4 = "Manufacturer";
            String string5 = "Product";
            String string6 = "Serial Number";
            String string7 = "UUID";
            String string8 = "Version";
            this.biosVendor = ParseUtil.getValueOrUnknown(map, "Vendor");
            this.biosVersion = ParseUtil.getValueOrUnknown(map, "Version String");
            this.biosDate = ParseUtil.getValueOrUnknown(map, "Release Date");
            this.manufacturer = ParseUtil.getValueOrUnknown(map2, "Manufacturer");
            this.model = ParseUtil.getValueOrUnknown(map2, "Product");
            this.serialNumber = ParseUtil.getValueOrUnknown(map2, "Serial Number");
            this.uuid = ParseUtil.getValueOrUnknown(map2, "UUID");
            this.boardManufacturer = ParseUtil.getValueOrUnknown(map3, "Manufacturer");
            this.boardModel = ParseUtil.getValueOrUnknown(map3, "Product");
            this.boardVersion = ParseUtil.getValueOrUnknown(map3, "Version");
            this.boardSerialNumber = ParseUtil.getValueOrUnknown(map3, "Serial Number");
        }
    }

    public static enum SmbType {
        SMB_TYPE_BIOS,
        SMB_TYPE_SYSTEM,
        SMB_TYPE_BASEBOARD;

    }
}

