/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.util.UndashedUuid;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class User {
    private final String name;
    private final UUID uuid;
    private final String accessToken;
    private final Optional<String> xuid;
    private final Optional<String> clientId;
    private final Type type;

    public User(String p_193799_, UUID p_296409_, String p_193800_, Optional<String> p_193802_, Optional<String> p_193803_, Type p_193804_) {
        this.name = p_193799_;
        this.uuid = p_296409_;
        this.accessToken = p_193800_;
        this.xuid = p_193802_;
        this.clientId = p_193803_;
        this.type = p_193804_;
    }

    public String getSessionId() {
        return "token:" + this.accessToken + ":" + UndashedUuid.toString((UUID)this.uuid);
    }

    public UUID getProfileId() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    public Optional<String> getXuid() {
        return this.xuid;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        LEGACY("legacy"),
        MOJANG("mojang"),
        MSA("msa");

        private static final Map<String, Type> BY_NAME;
        private final String name;

        private Type(String p_92558_) {
            this.name = p_92558_;
        }

        @Nullable
        public static Type byName(String p_92562_) {
            return BY_NAME.get(p_92562_.toLowerCase(Locale.ROOT));
        }

        public String getName() {
            return this.name;
        }

        static {
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(p_92560_ -> p_92560_.name, Function.identity()));
        }
    }
}

