/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class CycleButton<T>
extends AbstractButton {
    public static final BooleanSupplier DEFAULT_ALT_LIST_SELECTOR = Screen::hasAltDown;
    private static final List<Boolean> BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private final Component name;
    private int index;
    private T value;
    private final ValueListSupplier<T> values;
    private final Function<T, Component> valueStringifier;
    private final Function<CycleButton<T>, MutableComponent> narrationProvider;
    private final OnValueChange<T> onValueChange;
    private final boolean displayOnlyValue;
    private final OptionInstance.TooltipSupplier<T> tooltipSupplier;

    CycleButton(int p_232484_, int p_232485_, int p_232486_, int p_232487_, Component p_232488_, Component p_232489_, int p_232490_, T p_232491_, ValueListSupplier<T> p_232492_, Function<T, Component> p_232493_, Function<CycleButton<T>, MutableComponent> p_232494_, OnValueChange<T> p_232495_, OptionInstance.TooltipSupplier<T> p_232496_, boolean p_232497_) {
        super(p_232484_, p_232485_, p_232486_, p_232487_, p_232488_);
        this.name = p_232489_;
        this.index = p_232490_;
        this.value = p_232491_;
        this.values = p_232492_;
        this.valueStringifier = p_232493_;
        this.narrationProvider = p_232494_;
        this.onValueChange = p_232495_;
        this.displayOnlyValue = p_232497_;
        this.tooltipSupplier = p_232496_;
        this.updateTooltip();
    }

    private void updateTooltip() {
        this.setTooltip(this.tooltipSupplier.apply(this.value));
    }

    @Override
    public void onPress() {
        if (Screen.hasShiftDown()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int p_168909_) {
        List<T> $$1 = this.values.getSelectedList();
        this.index = Mth.positiveModulo(this.index + p_168909_, $$1.size());
        T $$2 = $$1.get(this.index);
        this.updateValue($$2);
        this.onValueChange.onValueChange(this, $$2);
    }

    private T getCycledValue(int p_168915_) {
        List<T> $$1 = this.values.getSelectedList();
        return $$1.get(Mth.positiveModulo(this.index + p_168915_, $$1.size()));
    }

    @Override
    public boolean mouseScrolled(double p_168885_, double p_168886_, double p_168887_, double p_294881_) {
        if (p_294881_ > 0.0) {
            this.cycleValue(-1);
        } else if (p_294881_ < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    public void setValue(T p_168893_) {
        List<T> $$1 = this.values.getSelectedList();
        int $$2 = $$1.indexOf(p_168893_);
        if ($$2 != -1) {
            this.index = $$2;
        }
        this.updateValue(p_168893_);
    }

    private void updateValue(T p_168906_) {
        Component $$1 = this.createLabelForValue(p_168906_);
        this.setMessage($$1);
        this.value = p_168906_;
        this.updateTooltip();
    }

    private Component createLabelForValue(T p_168911_) {
        return this.displayOnlyValue ? this.valueStringifier.apply(p_168911_) : this.createFullName(p_168911_);
    }

    private MutableComponent createFullName(T p_168913_) {
        return CommonComponents.optionNameValue(this.name, this.valueStringifier.apply(p_168913_));
    }

    public T getValue() {
        return this.value;
    }

    @Override
    protected MutableComponent createNarrationMessage() {
        return this.narrationProvider.apply(this);
    }

    @Override
    public void updateWidgetNarration(NarrationElementOutput p_168889_) {
        p_168889_.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            T $$1 = this.getCycledValue(1);
            Component $$2 = this.createLabelForValue($$1);
            if (this.isFocused()) {
                p_168889_.add(NarratedElementType.USAGE, (Component)Component.translatable("narration.cycle_button.usage.focused", $$2));
            } else {
                p_168889_.add(NarratedElementType.USAGE, (Component)Component.translatable("narration.cycle_button.usage.hovered", $$2));
            }
        }
    }

    public MutableComponent createDefaultNarrationMessage() {
        return CycleButton.wrapDefaultNarrationMessage(this.displayOnlyValue ? this.createFullName(this.value) : this.getMessage());
    }

    public static <T> Builder<T> builder(Function<T, Component> p_168895_) {
        return new Builder<T>(p_168895_);
    }

    public static Builder<Boolean> booleanBuilder(Component p_168897_, Component p_168898_) {
        return new Builder<Boolean>(p_168902_ -> p_168902_ != false ? p_168897_ : p_168898_).withValues((Collection<Boolean>)BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Boolean>(p_168891_ -> p_168891_ != false ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF).withValues((Collection<Boolean>)BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder(boolean p_168917_) {
        return CycleButton.onOffBuilder().withInitialValue(p_168917_);
    }

    public static interface ValueListSupplier<T> {
        public List<T> getSelectedList();

        public List<T> getDefaultList();

        public static <T> ValueListSupplier<T> create(Collection<T> p_232505_) {
            ImmutableList $$1 = ImmutableList.copyOf(p_232505_);
            return new ValueListSupplier<T>((List)$$1){
                final /* synthetic */ List val$copy;
                {
                    this.val$copy = list;
                }

                @Override
                public List<T> getSelectedList() {
                    return this.val$copy;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$copy;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier p_168971_, List<T> p_168972_, List<T> p_168973_) {
            ImmutableList $$3 = ImmutableList.copyOf(p_168972_);
            ImmutableList $$4 = ImmutableList.copyOf(p_168973_);
            return new ValueListSupplier<T>((List)$$4, (List)$$3){
                final /* synthetic */ List val$altCopy;
                final /* synthetic */ List val$defaultCopy;
                {
                    this.val$altCopy = list;
                    this.val$defaultCopy = list2;
                }

                @Override
                public List<T> getSelectedList() {
                    return p_168971_.getAsBoolean() ? this.val$altCopy : this.val$defaultCopy;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$defaultCopy;
                }
            };
        }
    }

    public static interface OnValueChange<T> {
        public void onValueChange(CycleButton<T> var1, T var2);
    }

    public static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T initialValue;
        private final Function<T, Component> valueStringifier;
        private OptionInstance.TooltipSupplier<T> tooltipSupplier = p_168964_ -> null;
        private Function<CycleButton<T>, MutableComponent> narrationProvider = CycleButton::createDefaultNarrationMessage;
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());
        private boolean displayOnlyValue;

        public Builder(Function<T, Component> p_168928_) {
            this.valueStringifier = p_168928_;
        }

        public Builder<T> withValues(Collection<T> p_232503_) {
            return this.withValues(ValueListSupplier.create(p_232503_));
        }

        @SafeVarargs
        public final Builder<T> withValues(T ... p_168962_) {
            return this.withValues((Collection<T>)ImmutableList.copyOf((Object[])p_168962_));
        }

        public Builder<T> withValues(List<T> p_168953_, List<T> p_168954_) {
            return this.withValues(ValueListSupplier.create(DEFAULT_ALT_LIST_SELECTOR, p_168953_, p_168954_));
        }

        public Builder<T> withValues(BooleanSupplier p_168956_, List<T> p_168957_, List<T> p_168958_) {
            return this.withValues(ValueListSupplier.create(p_168956_, p_168957_, p_168958_));
        }

        public Builder<T> withValues(ValueListSupplier<T> p_232501_) {
            this.values = p_232501_;
            return this;
        }

        public Builder<T> withTooltip(OptionInstance.TooltipSupplier<T> p_232499_) {
            this.tooltipSupplier = p_232499_;
            return this;
        }

        public Builder<T> withInitialValue(T p_168949_) {
            this.initialValue = p_168949_;
            int $$1 = this.values.getDefaultList().indexOf(p_168949_);
            if ($$1 != -1) {
                this.initialIndex = $$1;
            }
            return this;
        }

        public Builder<T> withCustomNarration(Function<CycleButton<T>, MutableComponent> p_168960_) {
            this.narrationProvider = p_168960_;
            return this;
        }

        public Builder<T> displayOnlyValue() {
            this.displayOnlyValue = true;
            return this;
        }

        public CycleButton<T> create(Component p_332061_, OnValueChange<T> p_332055_) {
            return this.create(0, 0, 150, 20, p_332061_, p_332055_);
        }

        public CycleButton<T> create(int p_168931_, int p_168932_, int p_168933_, int p_168934_, Component p_168935_) {
            return this.create(p_168931_, p_168932_, p_168933_, p_168934_, p_168935_, (p_168946_, p_168947_) -> {});
        }

        public CycleButton<T> create(int p_168937_, int p_168938_, int p_168939_, int p_168940_, Component p_168941_, OnValueChange<T> p_168942_) {
            List<T> $$6 = this.values.getDefaultList();
            if ($$6.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T $$7 = this.initialValue != null ? this.initialValue : $$6.get(this.initialIndex);
            Component $$8 = this.valueStringifier.apply($$7);
            Component $$9 = this.displayOnlyValue ? $$8 : CommonComponents.optionNameValue(p_168941_, $$8);
            return new CycleButton<T>(p_168937_, p_168938_, p_168939_, p_168940_, $$9, p_168941_, this.initialIndex, $$7, this.values, this.valueStringifier, this.narrationProvider, p_168942_, this.tooltipSupplier, this.displayOnlyValue);
        }
    }
}

