/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class MerchantScreen
extends AbstractContainerScreen<MerchantMenu> {
    private static final ResourceLocation OUT_OF_STOCK_SPRITE = ResourceLocation.withDefaultNamespace("container/villager/out_of_stock");
    private static final ResourceLocation EXPERIENCE_BAR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace("container/villager/experience_bar_background");
    private static final ResourceLocation EXPERIENCE_BAR_CURRENT_SPRITE = ResourceLocation.withDefaultNamespace("container/villager/experience_bar_current");
    private static final ResourceLocation EXPERIENCE_BAR_RESULT_SPRITE = ResourceLocation.withDefaultNamespace("container/villager/experience_bar_result");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace("container/villager/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace("container/villager/scroller_disabled");
    private static final ResourceLocation TRADE_ARROW_OUT_OF_STOCK_SPRITE = ResourceLocation.withDefaultNamespace("container/villager/trade_arrow_out_of_stock");
    private static final ResourceLocation TRADE_ARROW_SPRITE = ResourceLocation.withDefaultNamespace("container/villager/trade_arrow");
    private static final ResourceLocation DISCOUNT_STRIKETHRUOGH_SPRITE = ResourceLocation.withDefaultNamespace("container/villager/discount_strikethrough");
    private static final ResourceLocation VILLAGER_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/container/villager.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int MERCHANT_MENU_PART_X = 99;
    private static final int PROGRESS_BAR_X = 136;
    private static final int PROGRESS_BAR_Y = 16;
    private static final int SELL_ITEM_1_X = 5;
    private static final int SELL_ITEM_2_X = 35;
    private static final int BUY_ITEM_X = 68;
    private static final int LABEL_Y = 6;
    private static final int NUMBER_OF_OFFER_BUTTONS = 7;
    private static final int TRADE_BUTTON_X = 5;
    private static final int TRADE_BUTTON_HEIGHT = 20;
    private static final int TRADE_BUTTON_WIDTH = 88;
    private static final int SCROLLER_HEIGHT = 27;
    private static final int SCROLLER_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 139;
    private static final int SCROLL_BAR_TOP_POS_Y = 18;
    private static final int SCROLL_BAR_START_X = 94;
    private static final Component TRADES_LABEL = Component.translatable("merchant.trades");
    private static final Component DEPRECATED_TOOLTIP = Component.translatable("merchant.deprecated");
    private int shopItem;
    private final TradeOfferButton[] tradeOfferButtons = new TradeOfferButton[7];
    int scrollOff;
    private boolean isDragging;

    public MerchantScreen(MerchantMenu p_99123_, Inventory p_99124_, Component p_99125_) {
        super(p_99123_, p_99124_, p_99125_);
        this.imageWidth = 276;
        this.inventoryLabelX = 107;
    }

    private void postButtonClick() {
        ((MerchantMenu)this.menu).setSelectionHint(this.shopItem);
        ((MerchantMenu)this.menu).tryMoveItems(this.shopItem);
        this.minecraft.getConnection().send(new ServerboundSelectTradePacket(this.shopItem));
    }

    @Override
    protected void init() {
        super.init();
        int $$0 = (this.width - this.imageWidth) / 2;
        int $$1 = (this.height - this.imageHeight) / 2;
        int $$2 = $$1 + 16 + 2;
        for (int $$3 = 0; $$3 < 7; ++$$3) {
            this.tradeOfferButtons[$$3] = this.addRenderableWidget(new TradeOfferButton($$0 + 5, $$2, $$3, p_99174_ -> {
                if (p_99174_ instanceof TradeOfferButton) {
                    this.shopItem = ((TradeOfferButton)p_99174_).getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            $$2 += 20;
        }
    }

    @Override
    protected void renderLabels(GuiGraphics p_283337_, int p_282009_, int p_283691_) {
        int $$3 = ((MerchantMenu)this.menu).getTraderLevel();
        if ($$3 > 0 && $$3 <= 5 && ((MerchantMenu)this.menu).showProgressBar()) {
            MutableComponent $$4 = Component.translatable("merchant.title", this.title, Component.translatable("merchant.level." + $$3));
            int $$5 = this.font.width($$4);
            int $$6 = 49 + this.imageWidth / 2 - $$5 / 2;
            p_283337_.drawString(this.font, $$4, $$6, 6, 0x404040, false);
        } else {
            p_283337_.drawString(this.font, this.title, 49 + this.imageWidth / 2 - this.font.width(this.title) / 2, 6, 0x404040, false);
        }
        p_283337_.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
        int $$7 = this.font.width(TRADES_LABEL);
        p_283337_.drawString(this.font, TRADES_LABEL, 5 - $$7 / 2 + 48, 6, 0x404040, false);
    }

    @Override
    protected void renderBg(GuiGraphics p_283072_, float p_281275_, int p_282312_, int p_282984_) {
        int $$4 = (this.width - this.imageWidth) / 2;
        int $$5 = (this.height - this.imageHeight) / 2;
        p_283072_.blit(VILLAGER_LOCATION, $$4, $$5, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
        MerchantOffers $$6 = ((MerchantMenu)this.menu).getOffers();
        if (!$$6.isEmpty()) {
            int $$7 = this.shopItem;
            if ($$7 < 0 || $$7 >= $$6.size()) {
                return;
            }
            MerchantOffer $$8 = (MerchantOffer)$$6.get($$7);
            if ($$8.isOutOfStock()) {
                p_283072_.blitSprite(OUT_OF_STOCK_SPRITE, this.leftPos + 83 + 99, this.topPos + 35, 0, 28, 21);
            }
        }
    }

    private void renderProgressBar(GuiGraphics p_281426_, int p_283008_, int p_283085_, MerchantOffer p_282094_) {
        int $$4 = ((MerchantMenu)this.menu).getTraderLevel();
        int $$5 = ((MerchantMenu)this.menu).getTraderXp();
        if ($$4 >= 5) {
            return;
        }
        p_281426_.blitSprite(EXPERIENCE_BAR_BACKGROUND_SPRITE, p_283008_ + 136, p_283085_ + 16, 0, 102, 5);
        int $$6 = VillagerData.getMinXpPerLevel($$4);
        if ($$5 < $$6 || !VillagerData.canLevelUp($$4)) {
            return;
        }
        int $$7 = 102;
        float $$8 = 102.0f / (float)(VillagerData.getMaxXpPerLevel($$4) - $$6);
        int $$9 = Math.min(Mth.floor($$8 * (float)($$5 - $$6)), 102);
        p_281426_.blitSprite(EXPERIENCE_BAR_CURRENT_SPRITE, 102, 5, 0, 0, p_283008_ + 136, p_283085_ + 16, 0, $$9, 5);
        int $$10 = ((MerchantMenu)this.menu).getFutureTraderXp();
        if ($$10 > 0) {
            int $$11 = Math.min(Mth.floor((float)$$10 * $$8), 102 - $$9);
            p_281426_.blitSprite(EXPERIENCE_BAR_RESULT_SPRITE, 102, 5, $$9, 0, p_283008_ + 136 + $$9, p_283085_ + 16, 0, $$11, 5);
        }
    }

    private void renderScroller(GuiGraphics p_283030_, int p_283154_, int p_281664_, MerchantOffers p_282877_) {
        int $$4 = p_282877_.size() + 1 - 7;
        if ($$4 > 1) {
            int $$5 = 139 - (27 + ($$4 - 1) * 139 / $$4);
            int $$6 = 1 + $$5 / $$4 + 139 / $$4;
            int $$7 = 113;
            int $$8 = Math.min(113, this.scrollOff * $$6);
            if (this.scrollOff == $$4 - 1) {
                $$8 = 113;
            }
            p_283030_.blitSprite(SCROLLER_SPRITE, p_283154_ + 94, p_281664_ + 18 + $$8, 0, 6, 27);
        } else {
            p_283030_.blitSprite(SCROLLER_DISABLED_SPRITE, p_283154_ + 94, p_281664_ + 18, 0, 6, 27);
        }
    }

    @Override
    public void render(GuiGraphics p_283487_, int p_281994_, int p_282099_, float p_281815_) {
        super.render(p_283487_, p_281994_, p_282099_, p_281815_);
        MerchantOffers $$4 = ((MerchantMenu)this.menu).getOffers();
        if (!$$4.isEmpty()) {
            int $$5 = (this.width - this.imageWidth) / 2;
            int $$6 = (this.height - this.imageHeight) / 2;
            int $$7 = $$6 + 16 + 1;
            int $$8 = $$5 + 5 + 5;
            this.renderScroller(p_283487_, $$5, $$6, $$4);
            int $$9 = 0;
            for (MerchantOffer $$10 : $$4) {
                if (this.canScroll($$4.size()) && ($$9 < this.scrollOff || $$9 >= 7 + this.scrollOff)) {
                    ++$$9;
                    continue;
                }
                ItemStack $$11 = $$10.getBaseCostA();
                ItemStack $$12 = $$10.getCostA();
                ItemStack $$13 = $$10.getCostB();
                ItemStack $$14 = $$10.getResult();
                p_283487_.pose().pushPose();
                p_283487_.pose().translate(0.0f, 0.0f, 100.0f);
                int $$15 = $$7 + 2;
                this.renderAndDecorateCostA(p_283487_, $$12, $$11, $$8, $$15);
                if (!$$13.isEmpty()) {
                    p_283487_.renderFakeItem($$13, $$5 + 5 + 35, $$15);
                    p_283487_.renderItemDecorations(this.font, $$13, $$5 + 5 + 35, $$15);
                }
                this.renderButtonArrows(p_283487_, $$10, $$5, $$15);
                p_283487_.renderFakeItem($$14, $$5 + 5 + 68, $$15);
                p_283487_.renderItemDecorations(this.font, $$14, $$5 + 5 + 68, $$15);
                p_283487_.pose().popPose();
                $$7 += 20;
                ++$$9;
            }
            int $$16 = this.shopItem;
            MerchantOffer $$17 = (MerchantOffer)$$4.get($$16);
            if (((MerchantMenu)this.menu).showProgressBar()) {
                this.renderProgressBar(p_283487_, $$5, $$6, $$17);
            }
            if ($$17.isOutOfStock() && this.isHovering(186, 35, 22, 21, p_281994_, p_282099_) && ((MerchantMenu)this.menu).canRestock()) {
                p_283487_.renderTooltip(this.font, DEPRECATED_TOOLTIP, p_281994_, p_282099_);
            }
            for (TradeOfferButton $$18 : this.tradeOfferButtons) {
                if ($$18.isHoveredOrFocused()) {
                    $$18.renderToolTip(p_283487_, p_281994_, p_282099_);
                }
                $$18.visible = $$18.index < ((MerchantMenu)this.menu).getOffers().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.renderTooltip(p_283487_, p_281994_, p_282099_);
    }

    private void renderButtonArrows(GuiGraphics p_283020_, MerchantOffer p_281926_, int p_282752_, int p_282179_) {
        RenderSystem.enableBlend();
        if (p_281926_.isOutOfStock()) {
            p_283020_.blitSprite(TRADE_ARROW_OUT_OF_STOCK_SPRITE, p_282752_ + 5 + 35 + 20, p_282179_ + 3, 0, 10, 9);
        } else {
            p_283020_.blitSprite(TRADE_ARROW_SPRITE, p_282752_ + 5 + 35 + 20, p_282179_ + 3, 0, 10, 9);
        }
    }

    private void renderAndDecorateCostA(GuiGraphics p_281357_, ItemStack p_283466_, ItemStack p_282046_, int p_282403_, int p_283601_) {
        p_281357_.renderFakeItem(p_283466_, p_282403_, p_283601_);
        if (p_282046_.getCount() == p_283466_.getCount()) {
            p_281357_.renderItemDecorations(this.font, p_283466_, p_282403_, p_283601_);
        } else {
            p_281357_.renderItemDecorations(this.font, p_282046_, p_282403_, p_283601_, p_282046_.getCount() == 1 ? "1" : null);
            p_281357_.renderItemDecorations(this.font, p_283466_, p_282403_ + 14, p_283601_, p_283466_.getCount() == 1 ? "1" : null);
            p_281357_.pose().pushPose();
            p_281357_.pose().translate(0.0f, 0.0f, 300.0f);
            p_281357_.blitSprite(DISCOUNT_STRIKETHRUOGH_SPRITE, p_282403_ + 7, p_283601_ + 12, 0, 9, 2);
            p_281357_.pose().popPose();
        }
    }

    private boolean canScroll(int p_99141_) {
        return p_99141_ > 7;
    }

    @Override
    public boolean mouseScrolled(double p_99127_, double p_99128_, double p_99129_, double p_295610_) {
        int $$4 = ((MerchantMenu)this.menu).getOffers().size();
        if (this.canScroll($$4)) {
            int $$5 = $$4 - 7;
            this.scrollOff = Mth.clamp((int)((double)this.scrollOff - p_295610_), 0, $$5);
        }
        return true;
    }

    @Override
    public boolean mouseDragged(double p_99135_, double p_99136_, int p_99137_, double p_99138_, double p_99139_) {
        int $$5 = ((MerchantMenu)this.menu).getOffers().size();
        if (this.isDragging) {
            int $$6 = this.topPos + 18;
            int $$7 = $$6 + 139;
            int $$8 = $$5 - 7;
            float $$9 = ((float)p_99136_ - (float)$$6 - 13.5f) / ((float)($$7 - $$6) - 27.0f);
            $$9 = $$9 * (float)$$8 + 0.5f;
            this.scrollOff = Mth.clamp((int)$$9, 0, $$8);
            return true;
        }
        return super.mouseDragged(p_99135_, p_99136_, p_99137_, p_99138_, p_99139_);
    }

    @Override
    public boolean mouseClicked(double p_99131_, double p_99132_, int p_99133_) {
        this.isDragging = false;
        int $$3 = (this.width - this.imageWidth) / 2;
        int $$4 = (this.height - this.imageHeight) / 2;
        if (this.canScroll(((MerchantMenu)this.menu).getOffers().size()) && p_99131_ > (double)($$3 + 94) && p_99131_ < (double)($$3 + 94 + 6) && p_99132_ > (double)($$4 + 18) && p_99132_ <= (double)($$4 + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.mouseClicked(p_99131_, p_99132_, p_99133_);
    }

    class TradeOfferButton
    extends Button {
        final int index;

        public TradeOfferButton(int p_99205_, int p_99206_, int p_99207_, Button.OnPress p_99208_) {
            super(p_99205_, p_99206_, 88, 20, CommonComponents.EMPTY, p_99208_, DEFAULT_NARRATION);
            this.index = p_99207_;
            this.visible = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void renderToolTip(GuiGraphics p_281313_, int p_283342_, int p_283060_) {
            if (this.isHovered && ((MerchantMenu)MerchantScreen.this.menu).getOffers().size() > this.index + MerchantScreen.this.scrollOff) {
                if (p_283342_ < this.getX() + 20) {
                    ItemStack $$3 = ((MerchantOffer)((MerchantMenu)MerchantScreen.this.menu).getOffers().get(this.index + MerchantScreen.this.scrollOff)).getCostA();
                    p_281313_.renderTooltip(MerchantScreen.this.font, $$3, p_283342_, p_283060_);
                } else if (p_283342_ < this.getX() + 50 && p_283342_ > this.getX() + 30) {
                    ItemStack $$4 = ((MerchantOffer)((MerchantMenu)MerchantScreen.this.menu).getOffers().get(this.index + MerchantScreen.this.scrollOff)).getCostB();
                    if (!$$4.isEmpty()) {
                        p_281313_.renderTooltip(MerchantScreen.this.font, $$4, p_283342_, p_283060_);
                    }
                } else if (p_283342_ > this.getX() + 65) {
                    ItemStack $$5 = ((MerchantOffer)((MerchantMenu)MerchantScreen.this.menu).getOffers().get(this.index + MerchantScreen.this.scrollOff)).getResult();
                    p_281313_.renderTooltip(MerchantScreen.this.font, $$5, p_283342_, p_283060_);
                }
            }
        }
    }
}

