/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.CatCollarLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class CatRenderer
extends MobRenderer<Cat, CatModel<Cat>> {
    public CatRenderer(EntityRendererProvider.Context p_173943_) {
        super(p_173943_, new CatModel(p_173943_.bakeLayer(ModelLayers.CAT)), 0.4f);
        this.addLayer(new CatCollarLayer(this, p_173943_.getModelSet()));
    }

    @Override
    public ResourceLocation getTextureLocation(Cat p_113950_) {
        return p_113950_.getTextureId();
    }

    @Override
    protected void scale(Cat p_113952_, PoseStack p_113953_, float p_113954_) {
        super.scale(p_113952_, p_113953_, p_113954_);
        p_113953_.scale(0.8f, 0.8f, 0.8f);
    }

    @Override
    protected void setupRotations(Cat p_113956_, PoseStack p_113957_, float p_113958_, float p_113959_, float p_113960_, float p_320072_) {
        super.setupRotations(p_113956_, p_113957_, p_113958_, p_113959_, p_113960_, p_320072_);
        float $$6 = p_113956_.getLieDownAmount(p_113960_);
        if ($$6 > 0.0f) {
            p_113957_.translate(0.4f * $$6, 0.15f * $$6, 0.1f * $$6);
            p_113957_.mulPose(Axis.ZP.rotationDegrees(Mth.rotLerp($$6, 0.0f, 90.0f)));
            BlockPos $$7 = p_113956_.blockPosition();
            List<Player> $$8 = p_113956_.level().getEntitiesOfClass(Player.class, new AABB($$7).inflate(2.0, 2.0, 2.0));
            for (Player $$9 : $$8) {
                if (!$$9.isSleeping()) continue;
                p_113957_.translate(0.15f * $$6, 0.0f, 0.0f);
                break;
            }
        }
    }
}

