/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;

public class WeightedRandomList<E extends WeightedEntry> {
    private final int totalWeight;
    private final ImmutableList<E> items;

    WeightedRandomList(List<? extends E> p_146327_) {
        this.items = ImmutableList.copyOf(p_146327_);
        this.totalWeight = WeightedRandom.getTotalWeight(p_146327_);
    }

    public static <E extends WeightedEntry> WeightedRandomList<E> create() {
        return new WeightedRandomList<E>(ImmutableList.of());
    }

    @SafeVarargs
    public static <E extends WeightedEntry> WeightedRandomList<E> create(E ... p_146331_) {
        return new WeightedRandomList<E>(ImmutableList.copyOf((Object[])p_146331_));
    }

    public static <E extends WeightedEntry> WeightedRandomList<E> create(List<E> p_146329_) {
        return new WeightedRandomList<E>(p_146329_);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Optional<E> getRandom(RandomSource p_216830_) {
        if (this.totalWeight == 0) {
            return Optional.empty();
        }
        int $$1 = p_216830_.nextInt(this.totalWeight);
        return WeightedRandom.getWeightedItem(this.items, $$1);
    }

    public List<E> unwrap() {
        return this.items;
    }

    public static <E extends WeightedEntry> Codec<WeightedRandomList<E>> codec(Codec<E> p_146334_) {
        return p_146334_.listOf().xmap(WeightedRandomList::create, WeightedRandomList::unwrap);
    }

    public boolean equals(@Nullable Object p_338205_) {
        if (this == p_338205_) {
            return true;
        }
        if (p_338205_ == null || this.getClass() != p_338205_.getClass()) {
            return false;
        }
        WeightedRandomList $$1 = (WeightedRandomList)p_338205_;
        return this.totalWeight == $$1.totalWeight && Objects.equals(this.items, $$1.items);
    }

    public int hashCode() {
        return Objects.hash(this.totalWeight, this.items);
    }
}

