/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RecipeBookManager;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientRecipeBook
extends RecipeBook {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<RecipeBookCategories, List<RecipeCollection>> collectionsByTab = ImmutableMap.of();
    private List<RecipeCollection> allCollections = ImmutableList.of();

    public void setupCollections(Iterable<RecipeHolder<?>> p_266814_, RegistryAccess p_266878_) {
        Map<RecipeBookCategories, List<List<RecipeHolder<?>>>> map = ClientRecipeBook.categorizeAndGroupRecipes(p_266814_);
        HashMap map1 = Maps.newHashMap();
        ImmutableList.Builder builder = ImmutableList.builder();
        map.forEach((p_266602_, p_266603_) -> map1.put(p_266602_, (List)p_266603_.stream().map(p_266605_ -> new RecipeCollection(p_266878_, p_266605_)).peek(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)).collect(ImmutableList.toImmutableList())));
        RecipeBookCategories.AGGREGATE_CATEGORIES.forEach((p_90637_, p_90638_) -> map1.put(p_90637_, (List)p_90638_.stream().flatMap(p_167706_ -> ((List)map1.getOrDefault(p_167706_, ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList())));
        this.collectionsByTab = ImmutableMap.copyOf((Map)map1);
        this.allCollections = builder.build();
    }

    private static Map<RecipeBookCategories, List<List<RecipeHolder<?>>>> categorizeAndGroupRecipes(Iterable<RecipeHolder<?>> p_90643_) {
        HashMap map = Maps.newHashMap();
        HashBasedTable table = HashBasedTable.create();
        for (RecipeHolder<?> recipeholder : p_90643_) {
            String s;
            Recipe recipe = recipeholder.value();
            if (recipe.isSpecial() || recipe.isIncomplete()) continue;
            RecipeBookCategories recipebookcategories = ClientRecipeBook.getCategory(recipeholder);
            String string = s = recipe.getGroup().isEmpty() ? recipeholder.id().toString() : recipe.getGroup();
            if (s.isEmpty()) {
                map.computeIfAbsent(recipebookcategories, p_90645_ -> Lists.newArrayList()).add(ImmutableList.of(recipeholder));
                continue;
            }
            List list = (List)table.get((Object)recipebookcategories, (Object)s);
            if (list == null) {
                list = Lists.newArrayList();
                table.put((Object)recipebookcategories, (Object)s, (Object)list);
                map.computeIfAbsent(recipebookcategories, p_90641_ -> Lists.newArrayList()).add(list);
            }
            list.add(recipeholder);
        }
        return map;
    }

    private static RecipeBookCategories getCategory(RecipeHolder<?> p_301136_) {
        Recipe recipe = p_301136_.value();
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingrecipe = (CraftingRecipe)recipe;
            return switch (craftingrecipe.category()) {
                default -> throw new MatchException(null, null);
                case CraftingBookCategory.BUILDING -> RecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
                case CraftingBookCategory.EQUIPMENT -> RecipeBookCategories.CRAFTING_EQUIPMENT;
                case CraftingBookCategory.REDSTONE -> RecipeBookCategories.CRAFTING_REDSTONE;
                case CraftingBookCategory.MISC -> RecipeBookCategories.CRAFTING_MISC;
            };
        }
        RecipeType<?> recipetype = recipe.getType();
        if (recipe instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe abstractcookingrecipe = (AbstractCookingRecipe)recipe;
            CookingBookCategory cookingbookcategory = abstractcookingrecipe.category();
            if (recipetype == RecipeType.SMELTING) {
                return switch (cookingbookcategory) {
                    default -> throw new MatchException(null, null);
                    case CookingBookCategory.BLOCKS -> RecipeBookCategories.FURNACE_BLOCKS;
                    case CookingBookCategory.FOOD -> RecipeBookCategories.FURNACE_FOOD;
                    case CookingBookCategory.MISC -> RecipeBookCategories.FURNACE_MISC;
                };
            }
            if (recipetype == RecipeType.BLASTING) {
                return cookingbookcategory == CookingBookCategory.BLOCKS ? RecipeBookCategories.BLAST_FURNACE_BLOCKS : RecipeBookCategories.BLAST_FURNACE_MISC;
            }
            if (recipetype == RecipeType.SMOKING) {
                return RecipeBookCategories.SMOKER_FOOD;
            }
            if (recipetype == RecipeType.CAMPFIRE_COOKING) {
                return RecipeBookCategories.CAMPFIRE;
            }
        }
        if (recipetype == RecipeType.STONECUTTING) {
            return RecipeBookCategories.STONECUTTER;
        }
        if (recipetype == RecipeType.SMITHING) {
            return RecipeBookCategories.SMITHING;
        }
        RecipeBookCategories categories = RecipeBookManager.findCategories(recipetype, p_301136_);
        if (categories != null) {
            return categories;
        }
        LOGGER.warn("Unknown recipe category: {}/{}", LogUtils.defer(() -> BuiltInRegistries.RECIPE_TYPE.getKey(recipe.getType())), LogUtils.defer(() -> p_301136_.id()));
        return RecipeBookCategories.UNKNOWN;
    }

    public List<RecipeCollection> getCollections() {
        return this.allCollections;
    }

    public List<RecipeCollection> getCollection(RecipeBookCategories p_90624_) {
        return this.collectionsByTab.getOrDefault((Object)p_90624_, Collections.emptyList());
    }
}

