/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.gui;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ISubMenuHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.slot.InaccessibleSlot;
import appeng.util.inv.AppEngInternalInventory;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.ae2addonlib.api.ISetAmountMenuHost;
import net.pedroksl.ae2addonlib.registry.helpers.LibMenus;
import org.jetbrains.annotations.Nullable;

public class SetAmountMenu
extends AEBaseMenu
implements ISubMenu {
    private final ISubMenuHost host;
    private static final String ACTION_SET_STOCK_AMOUNT = "setStockAmount";
    private GenericStack stack;
    private Consumer<GenericStack> consumer;
    private final Slot itemSlot;
    private ISetAmountMenuHost menuToReturnTo;
    @GuiSync(value=1)
    private long initialAmount = -1L;
    @GuiSync(value=2)
    private long maxAmount = -1L;

    public SetAmountMenu(int id, Inventory playerInventory, ISubMenuHost host) {
        this(id, playerInventory, host, null);
    }

    public SetAmountMenu(int id, Inventory playerInventory, ISubMenuHost host, @Nullable ISetAmountMenuHost menuToReturnTo) {
        super(LibMenus.SET_AMOUNT.get(), id, playerInventory, (Object)host);
        this.host = host;
        this.menuToReturnTo = menuToReturnTo;
        this.itemSlot = new InaccessibleSlot((InternalInventory)new AppEngInternalInventory(1), 0);
        this.addSlot(this.itemSlot, SlotSemantics.MACHINE_OUTPUT);
        this.registerClientAction(ACTION_SET_STOCK_AMOUNT, Long.class, this::confirm);
    }

    public ISubMenuHost getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuHostLocator locator, GenericStack stack, Consumer<GenericStack> consumer) {
        SetAmountMenu.open(player, locator, stack, consumer, null, -1L);
    }

    public static void open(ServerPlayer player, MenuHostLocator locator, GenericStack stack, Consumer<GenericStack> consumer, ISetAmountMenuHost menuToReturnTo, long maxAmount) {
        MenuOpener.open(LibMenus.SET_AMOUNT.get(), (Player)player, (MenuHostLocator)locator);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof SetAmountMenu) {
            SetAmountMenu cca = (SetAmountMenu)abstractContainerMenu;
            cca.setStack(stack, maxAmount);
            cca.setConsumer(consumer);
            cca.setMenuToReturnTo(menuToReturnTo);
            cca.broadcastChanges();
        }
    }

    private void setStack(GenericStack stack, long maxAmount) {
        this.stack = Objects.requireNonNull(stack, "stack");
        this.initialAmount = stack.amount();
        this.maxAmount = maxAmount == -1L ? 64L * (long)stack.what().getAmountPerUnit() : maxAmount;
        this.itemSlot.set(stack.what().wrapForDisplayOrFilter());
    }

    private void setConsumer(Consumer<GenericStack> consumer) {
        this.consumer = consumer;
    }

    private void setMenuToReturnTo(ISetAmountMenuHost menuToReturnTo) {
        this.menuToReturnTo = menuToReturnTo;
    }

    public void confirm(long amount) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_STOCK_AMOUNT, amount);
            return;
        }
        if (amount <= 0L) {
            this.consumer.accept(null);
        } else {
            this.consumer.accept(new GenericStack(this.stack.what(), amount));
        }
        if (this.menuToReturnTo == null) {
            this.host.returnToMainMenu(this.getPlayer(), (ISubMenu)this);
        } else {
            this.menuToReturnTo.returnFromSetAmountMenu();
        }
    }

    public long getInitialAmount() {
        return this.initialAmount;
    }

    public long getMaxAmount() {
        return this.maxAmount;
    }

    @Nullable
    public AEKey getWhat() {
        GenericStack stack = GenericStack.fromItemStack((ItemStack)this.itemSlot.getItem());
        return stack != null ? stack.what() : null;
    }
}

