/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.registry;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ArmorMaterial;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.pedroksl.ae2addonlib.registry.helpers.MaterialDefinition;
import org.slf4j.Logger;

public class MaterialRegistry {
    private static final Logger LOG = LogUtils.getLogger();
    private static final Map<String, DeferredRegister<ArmorMaterial>> DRMap = new HashMap<String, DeferredRegister<ArmorMaterial>>();
    private static final Map<String, List<MaterialDefinition<?>>> MATERIALS = new HashMap();
    private final String modId;

    public MaterialRegistry(String modId) {
        if (DRMap.containsKey(modId) && FMLEnvironment.dist.isClient()) {
            LOG.error("Tried to initialize MaterialRegistry on Client Dist with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        this.modId = modId;
        DRMap.put(modId, (DeferredRegister<ArmorMaterial>)DeferredRegister.create((Registry)BuiltInRegistries.ARMOR_MATERIAL, (String)modId));
        MATERIALS.put(modId, new ArrayList());
    }

    static DeferredRegister<ArmorMaterial> getDR(String modId) {
        DeferredRegister dr = DRMap.getOrDefault(modId, null);
        if (dr == null) {
            LOG.error("Tried to access uninitialized deferred register with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        return dr;
    }

    public List<MaterialDefinition<?>> getMaterials() {
        return MaterialRegistry.getMaterials(this.modId);
    }

    public static List<MaterialDefinition<?>> getMaterials(String modId) {
        return Collections.unmodifiableList(MATERIALS.getOrDefault(modId, new ArrayList()));
    }

    protected static MaterialDefinition<ArmorMaterial> material(String modId, String englishName, String id, Supplier<ArmorMaterial> material) {
        MaterialDefinition<ArmorMaterial> definition = new MaterialDefinition<ArmorMaterial>(englishName, MaterialRegistry.getDR(modId).register(id, material));
        MATERIALS.get(modId).add(definition);
        return definition;
    }

    public void register(IEventBus eventBus) {
        MaterialRegistry.getDR(this.modId).register(eventBus);
    }
}

