/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.patterns;

import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.pedroksl.ae2addonlib.util.NullableDirection;

public record EncodedAdvProcessingPattern(List<GenericStack> sparseInputs, List<GenericStack> sparseOutputs, List<NullableDirection> directionList) {
    public static final Codec<EncodedAdvProcessingPattern> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)GenericStack.FAULT_TOLERANT_NULLABLE_LIST_CODEC.fieldOf("sparseInputs").forGetter(EncodedAdvProcessingPattern::sparseInputs), (App)GenericStack.FAULT_TOLERANT_NULLABLE_LIST_CODEC.fieldOf("sparseOutputs").forGetter(EncodedAdvProcessingPattern::sparseOutputs), (App)NullableDirection.FAULT_TOLERANT_NULLABLE_LIST_CODEC.fieldOf("directionMap").forGetter(EncodedAdvProcessingPattern::directionList)).apply((Applicative)builder, EncodedAdvProcessingPattern::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EncodedAdvProcessingPattern> STREAM_CODEC = StreamCodec.composite((StreamCodec)GenericStack.STREAM_CODEC.apply(ByteBufCodecs.list()), EncodedAdvProcessingPattern::sparseInputs, (StreamCodec)GenericStack.STREAM_CODEC.apply(ByteBufCodecs.list()), EncodedAdvProcessingPattern::sparseOutputs, (StreamCodec)NullableDirection.STREAM_CODEC.apply(ByteBufCodecs.list()), EncodedAdvProcessingPattern::directionList, EncodedAdvProcessingPattern::new);

    public EncodedAdvProcessingPattern {
        sparseInputs = Collections.unmodifiableList(sparseInputs);
        sparseOutputs = Collections.unmodifiableList(sparseOutputs);
        directionList = Collections.unmodifiableList(directionList);
    }

    public boolean containsMissingContent() {
        return Stream.concat(this.sparseInputs.stream(), this.sparseOutputs.stream()).anyMatch(stack -> stack != null && AEItems.MISSING_CONTENT.is(stack.what()));
    }
}

