/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.IType;
import com.yanny.ali.compatibility.jei.JeiLootSlotWidget;
import com.yanny.ali.compatibility.jei.JeiScrollWidget;
import com.yanny.ali.compatibility.jei.JeiWidgetWrapper;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.plugin.client.ClientUtils;
import com.yanny.ali.plugin.common.NodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public abstract class JeiBaseLoot<T extends IType, V>
implements IRecipeCategory<RecipeHolder<T>> {
    static final int CATEGORY_WIDTH = 162;
    static final int CATEGORY_HEIGHT = 126;
    protected final IGuiHelper guiHelper;
    private final RecipeType<RecipeHolder<T>> recipeType;
    private final LootCategory<V> lootCategory;
    private final Component title;
    private final IDrawable icon;

    public JeiBaseLoot(IGuiHelper guiHelper, RecipeType<RecipeHolder<T>> recipeType, LootCategory<V> lootCategory, Component title, IDrawable icon) {
        this.guiHelper = guiHelper;
        this.recipeType = recipeType;
        this.lootCategory = lootCategory;
        this.title = title;
        this.icon = icon;
    }

    @NotNull
    public final RecipeType<RecipeHolder<T>> getRecipeType() {
        return this.recipeType;
    }

    @NotNull
    public final Component getTitle() {
        return this.title;
    }

    public final IDrawable getIcon() {
        return this.icon;
    }

    public LootCategory<V> getLootCategory() {
        return this.lootCategory;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<T> recipe, IFocusGroup iFocusGroup) {
        LinkedList<Holder> slotParams = new LinkedList<Holder>();
        IWidgetUtils utils = this.getJeiUtils(slotParams);
        RelativeRect rect = new RelativeRect(0, this.getYOffset(recipe.type()), 162, 0);
        recipe.setWidgetWrapper(new JeiWidgetWrapper(this.getRootWidget(utils, recipe.type().entry(), rect, 162)));
        recipe.setHolders(slotParams);
        recipe.type().inputs().forEach(i -> builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(i));
        recipe.type().outputs().forEach(i -> builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(i));
        for (int i2 = 0; i2 < slotParams.size(); ++i2) {
            Holder h = (Holder)slotParams.get(i2);
            IRecipeSlotBuilder slotBuilder = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.RENDER_ONLY).setStandardSlotBackground().setSlotName(String.valueOf(i2)).setPosition(h.rect.getX(), h.rect.getY())).addRichTooltipCallback((iRecipeSlotView, tooltipBuilder) -> tooltipBuilder.addAll(NodeUtils.toComponents(h.entry().getTooltip(), 0, Minecraft.getInstance().options.advancedItemTooltips)));
            Optional left = h.item.left();
            Optional right = h.item.right();
            left.ifPresent(arg_0 -> ((IRecipeSlotBuilder)slotBuilder).addItemStack(arg_0));
            right.ifPresent(t -> slotBuilder.addIngredients(Ingredient.of((TagKey)t)));
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<T> recipe, IFocusGroup focuses) {
        JeiWidgetWrapper widgetWrapper = recipe.getWidgetWrapper();
        List<Holder> slotParams = recipe.getHolders();
        if (widgetWrapper == null || slotParams == null) {
            return;
        }
        Pair<List<IRecipeWidget>, List<IRecipeSlotDrawable>> additionalWidgets = this.getWidgets(builder, recipe.type());
        LinkedList<IRecipeWidget> scrollWidgets = new LinkedList<IRecipeWidget>((Collection)additionalWidgets.getA());
        LinkedList slotDrawables = new LinkedList((Collection)additionalWidgets.getB());
        scrollWidgets.add(widgetWrapper);
        for (int i = 0; i < slotParams.size(); ++i) {
            Holder h = slotParams.get(i);
            builder.getRecipeSlots().findSlotByName(String.valueOf(i)).ifPresent(slotDrawable -> {
                scrollWidgets.add((IRecipeWidget)new JeiLootSlotWidget((IRecipeSlotDrawable)slotDrawable, h.rect.getX(), h.rect.getY(), ((IItemNode)((Object)h.entry)).getCount()));
                slotDrawables.add(slotDrawable);
            });
        }
        Rect renderRect = new Rect(0, 0, 162 + JeiScrollWidget.getScrollBoxScrollbarExtraWidth(), 126);
        JeiScrollWidget scrollWidget = new JeiScrollWidget(renderRect, widgetWrapper.getRect().height() + this.getYOffset(recipe.type()), scrollWidgets);
        builder.addSlottedWidget((ISlottedRecipeWidget)scrollWidget, slotDrawables);
        builder.addInputHandler((IJeiInputHandler)scrollWidget);
    }

    public int getWidth() {
        return 162 + JeiScrollWidget.getScrollBoxScrollbarExtraWidth();
    }

    public int getHeight() {
        return 126;
    }

    abstract Pair<List<IRecipeWidget>, List<IRecipeSlotDrawable>> getWidgets(IRecipeExtrasBuilder var1, T var2);

    abstract int getYOffset(T var1);

    abstract IWidget getRootWidget(IWidgetUtils var1, IDataNode var2, RelativeRect var3, int var4);

    @NotNull
    protected IRecipeWidget createTextWidget(final Component component, final int x, final boolean centered) {
        return this.guiHelper.createWidgetFromDrawable(new IDrawable(){

            public int getWidth() {
                return 162;
            }

            public int getHeight() {
                return 8;
            }

            public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
                if (centered) {
                    int width = Minecraft.getInstance().font.width((FormattedText)component);
                    guiGraphics.drawString(Minecraft.getInstance().font, component, x - width / 2, 0, 0, false);
                } else {
                    guiGraphics.drawString(Minecraft.getInstance().font, component, x, 0, 0, false);
                }
            }
        }, x, 0);
    }

    @NotNull
    private IWidgetUtils getJeiUtils(final List<Holder> slotParams) {
        return new ClientUtils(this){

            @Override
            public void addSlotWidget(Either<ItemStack, TagKey<? extends ItemLike>> item, IDataNode entry, RelativeRect rect) {
                slotParams.add(new Holder(item, entry, rect));
            }
        };
    }

    public record Holder(Either<ItemStack, TagKey<? extends ItemLike>> item, IDataNode entry, RelativeRect rect) {
    }
}

