/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.configuration;

import de.srendi.advancedperipherals.common.configuration.GeneralConfig;
import de.srendi.advancedperipherals.common.configuration.IAPConfig;
import de.srendi.advancedperipherals.common.configuration.MetaphysicsConfig;
import de.srendi.advancedperipherals.common.configuration.PeripheralsConfig;
import de.srendi.advancedperipherals.common.configuration.WorldConfig;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.loading.FMLPaths;

public class APConfig {
    private static final Map<IConfigSpec, IAPConfig> KNOWN_CONFIGS = new HashMap<IConfigSpec, IAPConfig>();
    public static final GeneralConfig GENERAL_CONFIG = new GeneralConfig();
    public static final PeripheralsConfig PERIPHERALS_CONFIG = new PeripheralsConfig();
    public static final MetaphysicsConfig METAPHYSICS_CONFIG = new MetaphysicsConfig();
    public static final WorldConfig WORLD_CONFIG = new WorldConfig();

    public static void register(ModLoadingContext context) {
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve("Advancedperipherals"));
        ModContainer modContainer = context.getActiveContainer();
        APConfigHelper.registerConfig(KNOWN_CONFIGS, modContainer, GENERAL_CONFIG);
        APConfigHelper.registerConfig(KNOWN_CONFIGS, modContainer, PERIPHERALS_CONFIG);
        APConfigHelper.registerConfig(KNOWN_CONFIGS, modContainer, METAPHYSICS_CONFIG);
        APConfigHelper.registerConfig(KNOWN_CONFIGS, modContainer, WORLD_CONFIG);
    }

    public static class APConfigHelper {
        public static String getAPConfigFilePath(IAPConfig config) {
            return "Advancedperipherals/" + config.getFileName() + ".toml";
        }

        public static void registerConfig(Map<IConfigSpec, IAPConfig> knownConfigs, ModContainer modContainer, IAPConfig config) {
            modContainer.registerConfig(config.getType(), (IConfigSpec)config.getConfigSpec(), APConfigHelper.getAPConfigFilePath(config));
            knownConfigs.put((IConfigSpec)config.getConfigSpec(), config);
        }
    }
}

