/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.util.DataComponentUtil;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.GenericFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidFilter
extends GenericFilter<FluidStack> {
    public static final FluidFilter EMPTY = new FluidFilter();
    private Fluid fluid = Fluids.EMPTY;
    private TagKey<Fluid> tag = null;
    private Tag componentsAsNbt = null;
    private PatchedDataComponentMap components;
    private int count = 1000;
    private String fingerprint = "";

    private FluidFilter() {
    }

    public static Pair<FluidFilter, String> parse(LuaTable<?, ?> item) {
        if (item.isEmpty()) {
            return Pair.of(EMPTY, null);
        }
        FluidFilter fluidFilter = FluidFilter.createEmpty();
        if (item.containsKey((Object)"name")) {
            try {
                String name = item.getString("name");
                if (name.startsWith("#")) {
                    fluidFilter.tag = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.parse((String)name.substring(1)));
                } else {
                    fluidFilter.fluid = (Fluid)ItemUtil.getRegistryEntry(name, BuiltInRegistries.FLUID);
                    if (fluidFilter.fluid == null) {
                        return Pair.of(null, "FLUID_NOT_FOUND");
                    }
                }
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FLUID");
            }
        }
        if (item.containsKey((Object)"components")) {
            try {
                fluidFilter.componentsAsNbt = NBTUtil.fromText(item.getString("components"));
            }
            catch (LuaException luaException) {
                try {
                    fluidFilter.componentsAsNbt = NBTUtil.fromText(item.getTable("components").toString());
                }
                catch (LuaException e) {
                    return Pair.of(null, "NO_VALID_COMPONENTS");
                }
            }
        }
        if (item.containsKey((Object)"fingerprint")) {
            try {
                fluidFilter.fingerprint = item.getString("fingerprint");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FINGERPRINT");
            }
        }
        if (item.containsKey((Object)"count")) {
            try {
                fluidFilter.count = item.getInt("count");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_COUNT");
            }
        }
        AdvancedPeripherals.debug("Parsed fluid filter: " + String.valueOf(fluidFilter));
        return Pair.of(fluidFilter, null);
    }

    public static FluidFilter fromStack(FluidStack stack) {
        FluidFilter filter = FluidFilter.createEmpty();
        filter.fluid = stack.getFluid();
        filter.componentsAsNbt = DataComponentUtil.toNbt(stack.getComponentsPatch());
        filter.components = stack.getComponents();
        return filter;
    }

    public static FluidFilter createEmpty() {
        return new FluidFilter();
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY || this.fingerprint.isEmpty() && this.fluid == Fluids.EMPTY && this.tag == null && this.componentsAsNbt == null;
    }

    @Override
    public boolean testAE(GenericStack genericStack) {
        if (!APAddon.AE2.isLoaded()) {
            return false;
        }
        AEKey aEKey = genericStack.what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey aeFluidKey = (AEFluidKey)aEKey;
            return this.test(aeFluidKey.toStack(1));
        }
        return false;
    }

    @Override
    public boolean testRS(ResourceAmount resourceAmount) {
        if (!APAddon.REFINEDSTORAGE.isLoaded()) {
            return false;
        }
        com.refinedmods.refinedstorage.api.resource.ResourceKey resourceKey = resourceAmount.resource();
        if (resourceKey instanceof FluidResource) {
            FluidResource fluidResource = (FluidResource)resourceKey;
            return this.test(VariantUtil.toFluidStack((FluidResource)fluidResource, (long)1L));
        }
        return false;
    }

    public FluidStack toFluidStack() {
        FluidStack result = new FluidStack(this.fluid, this.count);
        if (this.componentsAsNbt != null) {
            result.applyComponents((DataComponentMap)this.components);
        }
        return result;
    }

    public FluidFilter setCount(int count) {
        this.count = count;
        return this;
    }

    @Override
    public boolean test(FluidStack stack) {
        if (!this.fingerprint.isEmpty()) {
            String testFingerprint = FluidUtil.getFingerprint(stack);
            return this.fingerprint.equals(testFingerprint);
        }
        if (this.fluid != Fluids.EMPTY && !stack.getFluid().isSame(this.fluid)) {
            return false;
        }
        if (this.tag != null && !stack.getFluid().is(this.tag)) {
            return false;
        }
        return this.componentsAsNbt == null || DataComponentUtil.toNbt(stack.getComponentsPatch()).equals((Object)this.componentsAsNbt);
    }

    public int getCount() {
        return this.count;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public Tag getComponentsAsNbt() {
        return this.componentsAsNbt;
    }

    public String toString() {
        return "FluidFilter{fluid=" + String.valueOf(FluidUtil.getRegistryKey(this.fluid)) + ", tag=" + String.valueOf(this.tag) + ", components=" + String.valueOf(this.componentsAsNbt) + ", count=" + this.count + ", fingerprint='" + this.fingerprint + "'}";
    }
}

