/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import de.srendi.advancedperipherals.common.util.FingerprintUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemUtil {
    private ItemUtil() {
    }

    public static <T> T getRegistryEntry(String name, Registry<T> forgeRegistry) {
        Object value;
        ResourceLocation location;
        try {
            location = ResourceLocation.parse((String)name);
        }
        catch (ResourceLocationException ex) {
            location = null;
        }
        if (location != null && forgeRegistry.containsKey(location) && (value = forgeRegistry.get(location)) != null) {
            return (T)value;
        }
        return null;
    }

    public static String getFingerprint(ItemStack stack) {
        FingerprintUtil.FingerprintKey fingerprintKey = new FingerprintUtil.FingerprintKey(ItemUtil.getRegistryKey(stack), stack.getComponentsPatch().hashCode(), stack.getDisplayName().getString());
        return FingerprintUtil.hash(fingerprintKey);
    }

    public static List<ItemStack> getItemsFromItemHandler(IItemHandler handler) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(handler.getSlots());
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            items.add(handler.getStackInSlot(slot).copy());
        }
        return items;
    }

    public static ResourceLocation getRegistryKey(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getRegistryKey(ItemStack item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.copy().getItem());
    }
}

