/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.mobs.registries.InvaderRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.block_entity.TickingEntityBlock;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BossSpawnerBlock
extends Block
implements TickingEntityBlock {
    private static final VoxelShape OCC_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)0.0);

    public BossSpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BossSpawnerTile(pPos, pState);
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return OCC_SHAPE;
    }

    public static class BossSpawnerTile
    extends BlockEntity
    implements TickingBlockEntity {
        protected DynamicHolder<Invader> item = InvaderRegistry.INSTANCE.emptyHolder();
        protected int ticks = 0;

        public BossSpawnerTile(BlockPos pos, BlockState state) {
            super(Apoth.Tiles.BOSS_SPAWNER, pos, state);
        }

        public void serverTick(Level pLevel, BlockPos pos, BlockState pState) {
            if (this.ticks++ % 40 == 0) {
                Optional opt = this.level.getEntities((EntityTypeTest)EntityType.PLAYER, new AABB(this.worldPosition).inflate(8.0, 8.0, 8.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR).stream().findFirst();
                opt.ifPresent(player -> {
                    Invader bossItem;
                    this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
                    GenContext ctx = GenContext.forPlayerAtPos(this.level.random, player, pos);
                    Invader invader = bossItem = !this.item.isBound() ? InvaderRegistry.INSTANCE.getRandomItem(ctx) : (Invader)this.item.get();
                    if (bossItem == null) {
                        Apotheosis.LOGGER.error("A boss spawner attempted to spawn a boss at {} in {}, but no bosses were available!", (Object)this.getBlockPos(), (Object)this.level.dimension().location());
                        return;
                    }
                    Mob entity = bossItem.createBoss((ServerLevelAccessor)((ServerLevel)this.level), pos, ctx);
                    entity.setTarget((LivingEntity)player);
                    entity.setPersistenceRequired();
                    ((ServerLevel)this.level).addFreshEntityWithPassengers((Entity)entity);
                });
            }
        }

        public void setBossItem(DynamicHolder<Invader> item) {
            this.item = item;
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            if (this.item != null) {
                tag.putString("boss_item", this.item.getId().toString());
            }
            super.saveAdditional(tag, registries);
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            if (tag.contains("boss_item")) {
                this.item = InvaderRegistry.INSTANCE.holder(ResourceLocation.tryParse((String)tag.getString("boss_item")));
            }
            super.loadAdditional(tag, registries);
        }
    }
}

