/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.net;

import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.util.ItemLinking;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record LinkItemToChatPayload(int containerId, int slot, Item intendedItem) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LinkItemToChatPayload> TYPE = new CustomPacketPayload.Type(Apotheosis.loc("link_item_to_chat"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LinkItemToChatPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, LinkItemToChatPayload::containerId, (StreamCodec)ByteBufCodecs.INT, LinkItemToChatPayload::slot, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), LinkItemToChatPayload::intendedItem, LinkItemToChatPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Provider
    implements PayloadProvider<LinkItemToChatPayload> {
        public CustomPacketPayload.Type<LinkItemToChatPayload> getType() {
            return TYPE;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, LinkItemToChatPayload> getCodec() {
            return CODEC;
        }

        public void handle(LinkItemToChatPayload msg, IPayloadContext ctx) {
            Player player = ctx.player();
            if (ItemLinking.isOnCooldown(player.getUUID(), player.level().getGameTime())) {
                return;
            }
            if (!AdventureConfig.enableItemLinking) {
                player.sendSystemMessage((Component)Apotheosis.lang("message", "item_linking_disabled", new Object[0]));
                return;
            }
            AbstractContainerMenu menu = player.containerMenu;
            if (menu.containerId == msg.containerId && menu.slots.size() > msg.slot) {
                Slot slot = menu.getSlot(msg.slot);
                ItemStack stack = slot.getItem();
                int count = stack.getCount();
                if (count > 99) {
                    stack = stack.copyWithCount(99);
                }
                if (stack.getItem() == msg.intendedItem) {
                    Component comp = stack.getDisplayName();
                    if (count > 1) {
                        comp = Apotheosis.lang("chat", "link_item_with_count", String.valueOf(count), comp);
                    }
                    PlayerChatMessage chatMsg = PlayerChatMessage.system((String)"").withUnsignedContent(comp);
                    player.getServer().getPlayerList().broadcastChatMessage(chatMsg, (ServerPlayer)player, ChatType.bind((ResourceKey)ChatType.CHAT, (Entity)player));
                    ItemLinking.startCooldown(player.getUUID(), player.level().getGameTime());
                }
            }
        }

        public List<ConnectionProtocol> getSupportedProtocols() {
            return List.of(ConnectionProtocol.PLAY);
        }

        public Optional<PacketFlow> getFlow() {
            return Optional.of(PacketFlow.SERVERBOUND);
        }

        public String getVersion() {
            return "1";
        }
    }
}

