/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.apothic_spawners.modifiers.SpawnerModifier;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStat;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStats;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class ModifierTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, ApothSpawnerTile tile, SpawnerModifier modif) {
        this.trigger(player, inst -> inst.test(player, tile, modif));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints minDelay, MinMaxBounds.Ints maxDelay, MinMaxBounds.Ints spawnCount, MinMaxBounds.Ints nearbyEnts, MinMaxBounds.Ints playerRange, MinMaxBounds.Ints spawnRange, Optional<Boolean> ignorePlayers, Optional<Boolean> ignoreConditions, Optional<Boolean> redstone, Optional<Boolean> ignoreLight, Optional<Boolean> noAI, Optional<Boolean> silent, Optional<Boolean> youthful) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("min_delay", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::minDelay), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("max_delay", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::maxDelay), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("spawn_count", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::spawnCount), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("max_nearby_entities", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::nearbyEnts), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("req_player_range", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::playerRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("spawn_range", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::spawnRange), (App)Codec.BOOL.optionalFieldOf("ignore_players").forGetter(TriggerInstance::ignorePlayers), (App)Codec.BOOL.optionalFieldOf("ignore_conditions").forGetter(TriggerInstance::ignoreConditions), (App)Codec.BOOL.optionalFieldOf("redstone_control").forGetter(TriggerInstance::redstone), (App)Codec.BOOL.optionalFieldOf("ignore_light").forGetter(TriggerInstance::ignoreLight), (App)Codec.BOOL.optionalFieldOf("no_ai").forGetter(TriggerInstance::noAI), (App)Codec.BOOL.optionalFieldOf("silent").forGetter(TriggerInstance::silent), (App)Codec.BOOL.optionalFieldOf("youthful").forGetter(TriggerInstance::youthful)).apply((Applicative)inst, TriggerInstance::new));

        public boolean test(ServerPlayer player, ApothSpawnerTile tile, SpawnerModifier modif) {
            ApothSpawnerTile.SpawnerLogicExt logic = (ApothSpawnerTile.SpawnerLogicExt)tile.spawner;
            if (!this.minDelay.matches(logic.minSpawnDelay)) {
                return false;
            }
            if (!this.maxDelay.matches(logic.maxSpawnDelay)) {
                return false;
            }
            if (!this.spawnCount.matches(logic.spawnCount)) {
                return false;
            }
            if (!this.nearbyEnts.matches(logic.maxNearbyEntities)) {
                return false;
            }
            if (!this.playerRange.matches(logic.requiredPlayerRange)) {
                return false;
            }
            if (!this.spawnRange.matches(logic.spawnRange)) {
                return false;
            }
            if (!this.check(tile, SpawnerStats.IGNORE_PLAYERS, this.ignorePlayers)) {
                return false;
            }
            if (!this.check(tile, SpawnerStats.IGNORE_CONDITIONS, this.ignoreConditions)) {
                return false;
            }
            if (!this.check(tile, SpawnerStats.REDSTONE_CONTROL, this.redstone)) {
                return false;
            }
            if (!this.check(tile, SpawnerStats.IGNORE_LIGHT, this.ignoreLight)) {
                return false;
            }
            if (!this.check(tile, SpawnerStats.NO_AI, this.noAI)) {
                return false;
            }
            if (!this.check(tile, SpawnerStats.SILENT, this.silent)) {
                return false;
            }
            return this.check(tile, SpawnerStats.YOUTHFUL, this.youthful);
        }

        private <T> boolean check(ApothSpawnerTile tile, SpawnerStat<T> stat, Optional<T> target) {
            return target.isEmpty() || target.get() == stat.getValue(tile);
        }
    }
}

