/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.byAqua3.avaritia.compat.emi.AvaritiaEMIPlugin;
import net.byAqua3.avaritia.gui.GuiNeutronCollector;
import net.byAqua3.avaritia.recipe.RecipeCollector;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.Nullable;

public class EMIRecipeCollector
implements EmiRecipe {
    private final RecipeCollector recipe;
    private final ResourceLocation id;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;

    public EMIRecipeCollector(RecipeManager recipeManager, RecipeCollector recipe) {
        this.recipe = recipe;
        this.id = ResourceLocation.tryBuild((String)"avaritia", (String)"/collector");
        this.inputs = recipe.getIngredients().stream().map(ingredient -> EmiIngredient.of((Ingredient)ingredient)).toList();
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)));
    }

    public RecipeCollector getRecipe() {
        return this.recipe;
    }

    public EmiRecipeCategory getCategory() {
        return AvaritiaEMIPlugin.COLLECTOR;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 120;
    }

    public int getDisplayHeight() {
        return 55;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(GuiNeutronCollector.BACKGROUND_LOCATION, 11, 11, 102, 41, 37, 29, 102, 41, 256, 256);
        widgets.addText((Component)Component.translatable((String)"avaritia:container.neutron_collector.info", (Object[])new Object[]{Float.valueOf(5.92f)}), widgets.getWidth() / 2, widgets.getHeight() - 12, -12566464, false).horizontalAlign(TextWidget.Alignment.CENTER);
        widgets.addSlot((EmiIngredient)this.getOutputs().get(0), 53, widgets.getHeight() / 2 - 11).drawBack(false).recipeContext((EmiRecipe)this);
    }
}

