/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import net.byAqua3.avaritia.loader.AvaritiaTiers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;

public class ItemInfinityHoe
extends HoeItem {
    public ItemInfinityHoe(Item.Properties properties) {
        super((Tier)AvaritiaTiers.INFINITY, properties.attributes(HoeItem.createAttributes((Tier)AvaritiaTiers.INFINITY, (float)29.0f, (float)0.0f)));
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    private boolean applyBonemeal(Level level, BlockPos pos, Player player) {
        block1: {
            block3: {
                Block block;
                block2: {
                    BlockState blockState = level.getBlockState(pos);
                    block = blockState.getBlock();
                    if (!(block instanceof BonemealableBlock) || block instanceof GrassBlock || block instanceof TallGrassBlock || block instanceof DoublePlantBlock) break block1;
                    BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
                    if (!bonemealableBlock.isValidBonemealTarget((LevelReader)level, pos, blockState)) break block2;
                    if (!(level instanceof ServerLevel) || !bonemealableBlock.isBonemealSuccess(level, level.random, pos, blockState)) break block3;
                    bonemealableBlock.performBonemeal((ServerLevel)level, level.random, pos, blockState);
                    break block3;
                }
                level.destroyBlock(pos, true);
                for (ItemStack stack : player.getInventory().items) {
                    if (!(stack.getItem() instanceof BlockItem) || ((BlockItem)stack.getItem()).getBlock() != block) continue;
                    level.setBlockAndUpdate(pos, block.defaultBlockState());
                    if (player.isCreative()) break;
                    stack.shrink(1);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level;
        block5: {
            Player player;
            BlockPos blockPos;
            block4: {
                BlockState blockState;
                level = context.getLevel();
                blockPos = context.getClickedPos();
                player = context.getPlayer();
                if (!player.isShiftKeyDown()) break block4;
                if (this.applyBonemeal(level, blockPos, player) || (blockState = level.getBlockState(blockPos).getToolModifiedState(context, ItemAbilities.HOE_TILL, false)) == null) break block5;
                level.playSound(player, blockPos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (level.isClientSide) break block5;
                level.setBlock(blockPos, blockState, 11);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
                break block5;
            }
            int blockRange = (int)Math.round(4.0);
            for (int x = -blockRange; x <= blockRange; ++x) {
                for (int z = -blockRange; z <= blockRange; ++z) {
                    BlockPos rangePos = new BlockPos(Mth.floor((float)(blockPos.getX() + x)), Mth.floor((float)blockPos.getY()), Mth.floor((float)(blockPos.getZ() + z)));
                    BlockState rangeState = level.getBlockState(rangePos);
                    Block rangeBlock = rangeState.getBlock();
                    if (rangeBlock instanceof BonemealableBlock) {
                        this.applyBonemeal(level, rangePos, player);
                    } else {
                        this.applyBonemeal(level, rangePos.offset(0, 1, 0), player);
                    }
                    if (rangeState.getToolModifiedState(context, ItemAbilities.HOE_TILL, false) == null) continue;
                    rangeState = rangeState.getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
                    level.playSound(player, rangePos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (level.isClientSide) continue;
                    level.setBlock(rangePos, rangeState, 11);
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, rangePos, GameEvent.Context.of((Entity)player, (BlockState)rangeState));
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

