/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.item.ItemMatterCluster;
import net.byAqua3.avaritia.loader.AvaritiaBlockTags;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaTiers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ItemInfinityShovel
extends ShovelItem {
    public ItemInfinityShovel(Item.Properties properties) {
        super((Tier)AvaritiaTiers.INFINITY, properties.attributes(ShovelItem.createAttributes((Tier)AvaritiaTiers.INFINITY, (float)16.0f, (float)-2.0f)));
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity livingEntity) {
        int blockRange = (int)Math.round(8.0);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (stack.has((DataComponentType)AvaritiaDataComponents.DESTROYER.get()) && ((Boolean)stack.getOrDefault((DataComponentType)AvaritiaDataComponents.DESTROYER.get(), (Object)false)).booleanValue()) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int x = -blockRange; x <= blockRange; ++x) {
                    for (int y = -blockRange; y <= blockRange; ++y) {
                        for (int z = -blockRange; z <= blockRange; ++z) {
                            BlockPos rangePos = new BlockPos(Mth.floor((float)(pos.getX() + x)), Mth.floor((float)(pos.getY() + y)), Mth.floor((float)(pos.getZ() + z)));
                            BlockState rangeState = level.getBlockState(rangePos);
                            Block rangeBlock = rangeState.getBlock();
                            List tags = rangeState.getTags().toList();
                            if (rangeState.isAir() || !tags.contains(AvaritiaBlockTags.INFINITY_SHOVEL)) continue;
                            if (!level.isClientSide() && !player.isCreative()) {
                                List blockDrops = Block.getDrops((BlockState)rangeState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
                                if (!blockDrops.isEmpty()) {
                                    drops.addAll(blockDrops);
                                } else {
                                    ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)rangeBlock);
                                    Item blockItem = (Item)BuiltInRegistries.ITEM.get(blockKey);
                                    drops.add(new ItemStack((ItemLike)blockItem));
                                }
                            }
                            level.destroyBlock(rangePos, false);
                        }
                    }
                }
                if (!level.isClientSide() && !drops.isEmpty()) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ItemMatterCluster.makeCluster(drops));
                    itemEntity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)itemEntity);
                }
            }
        }
        return super.mineBlock(stack, level, state, pos, livingEntity);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                stack.update((DataComponentType)AvaritiaDataComponents.DESTROYER.get(), (Object)false, destroyer -> destroyer == false);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

