/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.tile;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.byAqua3.avaritia.component.ClusterContainerContents;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileExtremeCraftingTable
extends BlockEntity {
    public final SimpleContainer matrix = new SimpleContainer(81){

        public void setChanged() {
            TileExtremeCraftingTable.this.setChanged();
        }
    };
    public final SimpleContainer result = new SimpleContainer(1){

        public void setChanged() {
            TileExtremeCraftingTable.this.setChanged();
        }
    };

    public TileExtremeCraftingTable(BlockPos pos, BlockState state) {
        super((BlockEntityType)AvaritiaBlocks.EXTREME_CRAFTING_TABLE_TILE.get(), pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        int j;
        CompoundTag compoundTag;
        int i;
        ListTag tagList;
        super.loadAdditional(tag, provider);
        if (tag.contains("Matrix", 9)) {
            tagList = tag.getList("Matrix", 10);
            for (i = 0; i < tagList.size(); ++i) {
                compoundTag = tagList.getCompound(i);
                j = compoundTag.getByte("Slot") & 0xFF;
                if (j < 0 || j >= this.matrix.getItems().size()) continue;
                this.matrix.getItems().set(j, (Object)ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag).orElse(ItemStack.EMPTY));
            }
        }
        if (tag.contains("Result", 9)) {
            tagList = tag.getList("Result", 10);
            for (i = 0; i < tagList.size(); ++i) {
                compoundTag = tagList.getCompound(i);
                j = compoundTag.getByte("Slot") & 0xFF;
                if (j < 0 || j >= this.result.getItems().size()) continue;
                this.result.getItems().set(j, (Object)ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag).orElse(ItemStack.EMPTY));
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ListTag tagListMatrix = new ListTag();
        for (int i = 0; i < this.matrix.getItems().size(); ++i) {
            ItemStack itemStack = (ItemStack)this.matrix.getItems().get(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)i);
            tagListMatrix.add((Object)itemStack.save(provider, (Tag)compoundTag));
        }
        if (!tagListMatrix.isEmpty()) {
            tag.put("Matrix", (Tag)tagListMatrix);
        }
        ListTag tagListResult = new ListTag();
        for (int i = 0; i < this.result.getItems().size(); ++i) {
            ItemStack itemStack = (ItemStack)this.result.getItems().get(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)i);
            tagListResult.add((Object)itemStack.save(provider, (Tag)compoundTag));
        }
        if (!tagListResult.isEmpty()) {
            tag.put("Result", (Tag)tagListResult);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        NonNullList itemStacks = NonNullList.withSize((int)82, (Object)ItemStack.EMPTY);
        ((ClusterContainerContents)componentInput.getOrDefault(AvaritiaDataComponents.CLUSTER_CONTAINER, (Object)ClusterContainerContents.EMPTY)).copyInto((NonNullList<ItemStack>)itemStacks);
        if (!itemStacks.isEmpty()) {
            for (int i = 0; i < itemStacks.size(); ++i) {
                if (i < itemStacks.size() - 1) {
                    this.matrix.getItems().set(i, (Object)((ItemStack)itemStacks.get(i)));
                    continue;
                }
                this.result.getItems().set(0, (Object)((ItemStack)itemStacks.get(i)));
            }
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        List<ItemStack> itemStacks = Stream.concat(this.matrix.getItems().stream(), this.result.getItems().stream()).collect(Collectors.toList());
        builder.set(AvaritiaDataComponents.CLUSTER_CONTAINER, (Object)ClusterContainerContents.fromItems(itemStacks));
    }
}

