/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.newctm.json;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.client.newctm.CTMLogicBakery;
import team.chisel.ctm.client.newctm.CustomCTMLogic;
import team.chisel.ctm.client.newctm.ICTMLogic;
import team.chisel.ctm.client.newctm.TextureTypeCustom;
import team.chisel.ctm.client.newctm.json.CTMLogicDefinition;
import team.chisel.ctm.client.newctm.json.MultiSubmap;
import team.chisel.ctm.client.newctm.json.Position;
import team.chisel.ctm.client.newctm.json.Rule;
import team.chisel.ctm.client.texture.type.TextureTypeRegistry;
import team.chisel.ctm.client.util.Dir;
import team.chisel.ctm.client.util.Submap;

public class CTMDefinitionManager {
    private static final Logger log = LogManager.getLogger(CTMDefinitionManager.class);
    static final FileToIdConverter CTM_LOGIC_DEFINITIONS = FileToIdConverter.json((String)"ctm_logic");
    private final Map<ResourceLocation, ICTMLogic> logicDefinitions = new HashMap<ResourceLocation, ICTMLogic>();
    private final PreparableReloadListener reloadListener = new SimplePreparableReloadListener<Map<ResourceLocation, CTMLogicDefinition>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<ResourceLocation, CTMLogicDefinition> prepare(ResourceManager resources, ProfilerFiller profiler) {
            TextureTypeRegistry.lock.writeLock().lock();
            try {
                CTMDefinitionManager.this.logicDefinitions.keySet().forEach(id -> TextureTypeRegistry.remove(id.toString()));
                CTMDefinitionManager.this.logicDefinitions.clear();
                profiler.startTick();
                JsonOps ops = JsonOps.INSTANCE;
                Gson gson = new Gson();
                HashMap<ResourceLocation, CTMLogicDefinition> ret = new HashMap<ResourceLocation, CTMLogicDefinition>();
                for (Map.Entry entry : CTM_LOGIC_DEFINITIONS.listMatchingResources(resources).entrySet()) {
                    ResourceLocation fullLoc = (ResourceLocation)entry.getKey();
                    ResourceLocation id2 = CTM_LOGIC_DEFINITIONS.fileToId(fullLoc);
                    profiler.push(() -> ((ResourceLocation)id2).toString());
                    try {
                        BufferedReader r = ((Resource)entry.getValue()).openAsReader();
                        try {
                            profiler.push("reading");
                            JsonObject json = (JsonObject)GsonHelper.fromJson((Gson)gson, (Reader)r, JsonObject.class);
                            profiler.popPush("parsing");
                            DataResult dataresult = CTMLogicDefinition.CODEC.parse((DynamicOps)ops, (Object)json);
                            ret.put(id2, (CTMLogicDefinition)dataresult.getOrThrow());
                        }
                        finally {
                            if (r == null) continue;
                            r.close();
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to read CTM definition: {}", (Object)id2, (Object)e);
                    }
                    finally {
                        profiler.pop();
                        profiler.pop();
                    }
                }
                profiler.endTick();
                this.apply(ret, profiler);
                HashMap<ResourceLocation, CTMLogicDefinition> hashMap = ret;
                return hashMap;
            }
            finally {
                TextureTypeRegistry.lock.writeLock().unlock();
            }
        }

        protected void apply(Map<ResourceLocation, CTMLogicDefinition> values, ResourceManager resources, ProfilerFiller profiler) {
        }

        private void apply(Map<ResourceLocation, CTMLogicDefinition> values, ProfilerFiller profiler) {
            profiler.startTick();
            profiler.push("reloading");
            values.forEach((id, def) -> {
                CTMLogicBakery bakery = CTMDefinitionManager.createBakery(def);
                CustomCTMLogic logic = bakery.bake();
                CTMDefinitionManager.this.logicDefinitions.put((ResourceLocation)id, logic);
                TextureTypeRegistry.register(id.toString(), new TextureTypeCustom(logic));
            });
            profiler.pop();
            profiler.endTick();
        }

        public String getName() {
            return "CTMDefinitionManager";
        }
    };

    private static CTMLogicBakery createBakery(CTMLogicDefinition def) {
        CTMLogicBakery bakery = new CTMLogicBakery();
        Object2IntOpenHashMap bitNames = new Object2IntOpenHashMap();
        HashMap<String, Pair> submapNames = new HashMap<String, Pair>();
        HashMap<String, ISubmap> faceNames = new HashMap<String, ISubmap>();
        int bit = def.positions().size() - 1;
        for (Position position : def.positions()) {
            bitNames.put((Object)position.id(), bit);
            bakery.input(bit--, Dir.fromDirections(position.directions()));
        }
        int outputId = 0;
        for (Map.Entry<String, MultiSubmap> e : def.submaps().entrySet()) {
            for (Pair<String, ISubmap> p : e.getValue().forName(e.getKey())) {
                submapNames.put((String)p.getLeft(), Pair.of((Object)((ISubmap)p.getRight()), (Object)outputId++));
            }
        }
        for (Map.Entry<String, MultiSubmap> e : def.faces().entrySet()) {
            for (Pair<String, ISubmap> p : e.getValue().forName(e.getKey())) {
                faceNames.put((String)p.getLeft(), (ISubmap)p.getRight());
            }
        }
        for (Rule rule : def.rules()) {
            Pair submapData = (Pair)submapNames.get(rule.output());
            ISubmap submap = (ISubmap)submapData.getLeft();
            Integer ruleId = (Integer)submapData.getRight();
            bakery.output(ruleId, rule.from(), submap, rule.at().map(faceNames::get).orElse(Submap.X1));
            for (String connected : rule.connected()) {
                bakery.when(bitNames.getInt((Object)connected), true);
            }
            for (String unconnected : rule.unconnected()) {
                bakery.when(bitNames.getInt((Object)unconnected), false);
            }
        }
        return bakery;
    }

    @VisibleForTesting
    public static CustomCTMLogic fromReader(Reader r) {
        Gson gson = new Gson();
        JsonObject json = (JsonObject)GsonHelper.fromJson((Gson)gson, (Reader)r, JsonObject.class);
        JsonOps ops = JsonOps.INSTANCE;
        DataResult dataresult = CTMLogicDefinition.CODEC.parse((DynamicOps)ops, (Object)json);
        return CTMDefinitionManager.createBakery((CTMLogicDefinition)dataresult.getOrThrow()).bake();
    }

    public PreparableReloadListener getReloadListener() {
        return this.reloadListener;
    }
}

