/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ElementList;
import carbonconfiglib.gui.config.IIgnoreSearch;
import carbonconfiglib.gui.config.IListOwner;
import carbonconfiglib.gui.screen.MultiChoiceScreen;
import carbonconfiglib.gui.widgets.CarbonEditBox;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.Icon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class ListScreen
extends Screen
implements IListOwner {
    private static final Component LOG_INFO = Component.translatable((String)"gui.carbonconfig.logo.name").withStyle(ChatFormatting.GOLD).append("\n").append((Component)Component.translatable((String)"gui.carbonconfig.logo.page").withStyle(ChatFormatting.GRAY));
    protected ElementList visibleList;
    protected List<Element> allEntries = new ObjectArrayList();
    protected List<Component> tooltips = new ObjectArrayList();
    protected AbstractWidget activeWidget;
    protected long currentTick = 0L;
    protected long lastTick = -1L;
    protected double lastScroll = -1.0;
    protected CarbonEditBox searchBox;
    BackgroundTexture.BackgroundHolder customTexture;

    public ListScreen(Component name, BackgroundTexture.BackgroundHolder customTexture) {
        super(name);
        this.customTexture = customTexture;
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        this.allEntries.clear();
        this.visibleList = new ElementList(this.width, this.height - this.getFooterSpace() - this.getHeaderSpace(), this.getHeaderSpace(), this.height, this.getElementHeight());
        this.visibleList.setCustomBackground(this.customTexture);
        this.visibleList.setListWidth(this.getListWidth());
        this.visibleList.setScrollPadding(this.getScrollPadding());
        this.collectElements(this::addEntry);
        this.visibleList.addElements(this.sortElements(this.allEntries));
        this.addRenderableWidget((GuiEventListener)this.visibleList);
        if (this.shouldHaveSearch()) {
            this.searchBox = new CarbonEditBox(this.font, this.width / 2 - 100, 25, 200, 20);
            this.searchBox.setSuggestion(I18n.get((String)"gui.carbonconfig.search", (Object[])new Object[0]));
            this.searchBox.setResponder(T -> this.onSearchChange(this.searchBox, T.toLowerCase(Locale.ROOT)));
            this.addRenderableWidget((GuiEventListener)this.searchBox);
        }
        if (this.lastScroll >= 0.0) {
            this.visibleList.setScrollAmount(this.lastScroll);
        }
    }

    protected List<Element> sortElements(List<Element> list) {
        return list;
    }

    public void tick() {
        ++this.currentTick;
        super.tick();
        this.visibleList.tick();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        GuiUtils.drawTextureRegion(graphics, 5.0f, 5.0f, 40.0f, 40.0f, Icon.LOGO, 400.0f, 400.0f);
        if (mouseX >= 5 && mouseX <= 45 && mouseY >= 5 && mouseY <= 40) {
            this.addTooltips(LOG_INFO);
        }
        this.handleForground(graphics, mouseX, mouseY, partialTicks);
        if (!this.tooltips.isEmpty()) {
            ObjectArrayList text = new ObjectArrayList();
            for (Component entry : this.tooltips) {
                text.addAll(this.font.split((FormattedText)entry, Math.max(mouseX, this.width - mouseX) - 20));
            }
            graphics.renderTooltip(this.font, (List)text, mouseX, mouseY);
            this.tooltips.clear();
        }
    }

    public void handleForground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void removed() {
        this.lastScroll = this.visibleList.getScrollAmount();
        super.removed();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= 5.0 && mouseX <= 45.0 && mouseY >= 5.0 && mouseY <= 45.0) {
            this.activeWidget = null;
            MultiChoiceScreen screen = new MultiChoiceScreen(T -> {
                if (T.isMain()) {
                    this.openURL("https://curseforge.com/minecraft/mc-mods/carbon-config");
                } else if (T.isOther()) {
                    this.openURL("https://modrinth.com/mod/carbon-config");
                } else {
                    this.minecraft.setScreen((Screen)this);
                }
            }, (Component)Component.translatable((String)"gui.carbonconfig.logo.link.title"), (Component)Component.translatable((String)"gui.carbonconfig.logo.link.message").withStyle(ChatFormatting.GRAY), (Component)Component.translatable((String)"gui.carbonconfig.logo.link.curseforge"), (Component)Component.translatable((String)"gui.carbonconfig.logo.link.modrinth"), (Component)Component.translatable((String)"gui.carbonconfig.reset_all.cancel"));
            this.minecraft.setScreen((Screen)screen);
            return true;
        }
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (this.currentTick - this.lastTick >= 5L) {
            this.activeWidget = null;
        }
        return result;
    }

    private void openURL(String url) {
        this.minecraft.setScreen((Screen)new ConfirmLinkScreen(T -> {
            if (T) {
                Util.getPlatform().openUri(url);
            }
            this.minecraft.setScreen((Screen)this);
        }, url, true));
    }

    protected void addInternal(Element element) {
        element.owner = this;
        element.init();
    }

    protected void addEntry(Element element) {
        element.owner = this;
        this.allEntries.add(element);
        element.init();
    }

    protected abstract void collectElements(Consumer<Element> var1);

    protected void onSearchChange(EditBox box, String value) {
        this.onSearchChange(box, value, this.allEntries);
    }

    protected boolean onSearchChange(EditBox box, String value, List<Element> allEntries) {
        if (value.isEmpty()) {
            box.setSuggestion(I18n.get((String)"gui.carbonconfig.search", (Object[])new Object[0]));
            this.visibleList.updateList(allEntries);
            this.visibleList.setScrollAmount(this.visibleList.getScrollAmount());
            return true;
        }
        ObjectArrayList validElements = new ObjectArrayList();
        String suggestion = null;
        int m = allEntries.size();
        for (int i = 0; i < m; ++i) {
            String name;
            Element el = allEntries.get(i);
            if (IIgnoreSearch.shouldIgnoreSearch(el) || !(name = el.getName().toLowerCase(Locale.ROOT)).contains(value)) continue;
            validElements.add(el);
            if (!name.startsWith(value) || suggestion != null && suggestion.length() <= name.length()) continue;
            suggestion = el.getName();
        }
        if (validElements.size() > 0 && suggestion == null) {
            int offset;
            String sub;
            ObjectArrayList sorted;
            ObjectArrayList objectArrayList = sorted = validElements.size() > 2 ? new ObjectArrayList((Collection)validElements) : validElements;
            if (validElements.size() > 2) {
                sorted.sort(Comparator.comparing(Element::getName, Comparator.comparingInt(String::length).reversed()));
            }
            int m2 = sorted.size();
            for (int i = 0; i < m2 && (suggestion = (sub = ((Element)((Object)sorted.get(i))).getName()).substring(offset = sub.toLowerCase(Locale.ROOT).indexOf(value))).length() <= value.length(); ++i) {
            }
            if (suggestion.length() <= value.length()) {
                suggestion = null;
            }
        }
        if (validElements.isEmpty()) {
            box.setSuggestion("");
            this.visibleList.updateList((List<Element>)ObjectLists.emptyList());
            this.visibleList.setScrollAmount(this.visibleList.getScrollAmount());
            return false;
        }
        if (suggestion == null) {
            box.setSuggestion("");
        } else {
            box.setSuggestion(suggestion.substring(value.length()));
        }
        this.visibleList.updateList((List<Element>)validElements);
        this.visibleList.setScrollAmount(this.visibleList.getScrollAmount());
        return false;
    }

    protected boolean shouldHaveSearch() {
        return true;
    }

    protected boolean shouldHaveTooltips() {
        return true;
    }

    protected int getListWidth() {
        return 220;
    }

    protected int getScrollPadding() {
        return 124;
    }

    protected int getHeaderSpace() {
        return 50;
    }

    protected int getFooterSpace() {
        return 36;
    }

    protected int getElementHeight() {
        return 24;
    }

    @Override
    public void addTooltips(Component tooltip) {
        if (this.shouldHaveTooltips()) {
            this.tooltips.add(tooltip);
        }
    }

    @Override
    public boolean isInsideList(double mouseX, double mouseY) {
        return this.visibleList.isMouseOver(mouseX, mouseY);
    }

    @Override
    public boolean isActiveWidget(AbstractWidget widget) {
        return this.activeWidget == widget;
    }

    @Override
    public void setActiveWidget(AbstractWidget widget) {
        this.activeWidget = widget;
        this.lastTick = this.currentTick;
    }

    @Override
    public void updateInformation() {
        this.visibleList.children().forEach(Element::updateValues);
    }

    @Override
    public void removeEntry(Element element) {
    }

    @Override
    public BackgroundTexture.BackgroundHolder getCustomTexture() {
        return this.customTexture;
    }
}

