/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import carbonconfiglib.utils.MultilinePolicy;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class ConfigRequestPacket
implements ICarbonPacket {
    public static final StreamCodec<FriendlyByteBuf, ConfigRequestPacket> STREAM_CODEC = CustomPacketPayload.codec(ConfigRequestPacket::write, ICarbonPacket.readPacket(ConfigRequestPacket::new));
    public static final CustomPacketPayload.Type<ConfigRequestPacket> ID = ICarbonPacket.createType("carbonconfig:request_carbon");
    UUID id;
    String identifier;

    public ConfigRequestPacket(FriendlyByteBuf buffer) {
        this.id = buffer.readUUID();
        this.identifier = buffer.readUtf(Short.MAX_VALUE);
    }

    public ConfigRequestPacket(UUID id, String identifier) {
        this.id = id;
        this.identifier = identifier;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.id);
        buffer.writeUtf(this.identifier, Short.MAX_VALUE);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            return;
        }
        ConfigHandler handler = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeUtf(handler.getConfig().serialize(MultilinePolicy.DISABLED), 262144);
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.id, data), player);
    }
}

