/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.client.ClientHelper;
import chanceCubes.commands.CCubesRewardArguments;
import chanceCubes.commands.CCubesServerCommands;
import chanceCubes.components.CCubesDataComponents;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.containers.CCubesMenus;
import chanceCubes.items.CCubesItems;
import chanceCubes.listeners.PlayerConnectListener;
import chanceCubes.listeners.TickListener;
import chanceCubes.listeners.WorldGen;
import chanceCubes.modifier.CCubesModifiers;
import chanceCubes.network.CCubesNetwork;
import chanceCubes.rewards.DefaultGiantRewards;
import chanceCubes.rewards.DefaultRewards;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.util.NonreplaceableBlockOverride;
import chanceCubes.util.StatsRegistry;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chancecubes")
public class CCubesCore {
    public static final String MODID = "chancecubes";
    public static final Logger logger = LogManager.getLogger((String)"chancecubes");

    public CCubesCore(IEventBus eventBus, Dist dist, ModContainer container) {
        CCubesDataComponents.DATA_COMPONENT_TYPES.register(eventBus);
        CCubesBlocks.BLOCKS.register(eventBus);
        CCubesBlocks.BLOCK_ENTITIES.register(eventBus);
        CCubesItems.ITEMS.register(eventBus);
        CCubesItems.CREATIVE_MODE_TABS.register(eventBus);
        CCubesSounds.SOUNDS.register(eventBus);
        CCubesMenus.MENUS.register(eventBus);
        CCubesModifiers.BIOME_MODIFIER_SERIALIZERS.register(eventBus);
        CCubesRewardArguments.COMMAND_ARGUMENT_TYPES.register(eventBus);
        StatsRegistry.CUSTOM_STAT.register(eventBus);
        WorldGen.FEATURES.register(eventBus);
        eventBus.addListener(this::commonStart);
        eventBus.addListener(this::onIMCMessage);
        eventBus.addListener(CCubesNetwork::setupPackets);
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientHelper::registerMenuScreens);
            eventBus.addListener(ClientHelper::clientStart);
            eventBus.addListener(ClientHelper::onEntityRenders);
            NeoForge.EVENT_BUS.addListener(ClientHelper::onClientCommandsRegister);
        }
        NeoForge.EVENT_BUS.register((Object)this);
        ConfigLoader.initParentFolder();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigLoader.configSpec, MODID + File.separatorChar + "chancecubes-server.toml");
    }

    public void commonStart(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new PlayerConnectListener());
        NeoForge.EVENT_BUS.register((Object)new TickListener());
    }

    @SubscribeEvent
    public void lootTableLoad(LootTableLoadEvent event) {
        if (((Boolean)CCubesSettings.chestLoot.get()).booleanValue() && event.getName().getPath().contains("chests")) {
            event.getTable().addPool(LootPool.lootPool().name("chance_cubes_cubes").add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)CCubesItems.CHANCE_CUBE.get()))).build());
        }
    }

    @SubscribeEvent
    public void serverStart(ServerStartingEvent event) {
        RegistryAccess.Frozen provider = event.getServer().registryAccess();
        CCubesSettings.backupNRB.add(Blocks.BEDROCK.defaultBlockState());
        CCubesSettings.backupNRB.add(Blocks.OBSIDIAN.defaultBlockState());
        DefaultRewards.loadDefaultRewards((HolderLookup.Provider)provider);
        DefaultGiantRewards.loadDefaultRewards((HolderLookup.Provider)provider);
        CustomRewardsLoader.instance.loadCustomRewards((HolderLookup.Provider)provider);
        NonreplaceableBlockOverride.loadOverrides();
        logger.log(Level.INFO, "Death and destruction prepared! (And Cookies. Cookies were also prepared.)");
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        new CCubesServerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void onIMCMessage(InterModProcessEvent e) {
        e.getIMCStream().forEach(message -> {
            Object obj;
            Logger logger = LogManager.getLogger((String)MODID);
            if (message.method().equalsIgnoreCase("add-nonreplaceable") && (obj = message.messageSupplier().get()) instanceof BlockState) {
                BlockState state = (BlockState)obj;
                CCubesSettings.nonReplaceableBlocksIMC.add(state);
                logger.info(message.senderModId() + " has added the blockstate of \"" + String.valueOf(state) + "\" that Chance Cubes rewards will no longer replace.");
            }
        });
    }
}

