/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.client.gui;

import chanceCubes.client.ClientHelper;
import chanceCubes.containers.CreativePendantContainer;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.network.PacketCreativePendant;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreativePendantScreen
extends AbstractContainerScreen<CreativePendantContainer> {
    private static final ResourceLocation GUI_BG = ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"textures/gui/container/gui_creative_pendant.png");
    private int chanceValue = 0;

    public CreativePendantScreen(CreativePendantContainer pendantContainer, Inventory inv, Component component) {
        super((AbstractContainerMenu)pendantContainer, inv, component);
    }

    protected void init() {
        super.init();
        int halfWidth = this.width / 2;
        int halfHeight = this.height / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string("-1"), p_onPress_1_ -> this.changeChanceValue(-1)).bounds(halfWidth - 40, halfHeight - 60, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string("+1"), p_onPress_1_ -> this.changeChanceValue(1)).bounds(halfWidth + 15, halfHeight - 60, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string("-5"), p_onPress_1_ -> this.changeChanceValue(-5)).bounds(halfWidth - 60, halfHeight - 60, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string("+5"), p_onPress_1_ -> this.changeChanceValue(5)).bounds(halfWidth + 35, halfHeight - 60, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string("-10"), p_onPress_1_ -> this.changeChanceValue(-10)).bounds(halfWidth - 80, halfHeight - 60, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string("+10"), p_onPress_1_ -> this.changeChanceValue(10)).bounds(halfWidth + 55, halfHeight - 60, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentWrapper.string("Set Chance"), p_onPress_1_ -> ClientHelper.sendToServer(new PacketCreativePendant(this.chanceValue))).bounds(halfWidth + 12, halfHeight - 35, 70, 20).build());
    }

    public void changeChanceValue(int amount) {
        this.chanceValue += amount;
        if (this.chanceValue > 100) {
            this.chanceValue = 100;
        }
        if (this.chanceValue < -100) {
            this.chanceValue = -100;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_BG, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int p_97936_, int p_97937_) {
        guiGraphics.drawString(this.font, "Chance Value", 50, 5, 0, false);
        String cValue = String.valueOf(this.chanceValue);
        guiGraphics.drawString(this.font, cValue, 88 - cValue.length() * 3, 27, 0, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

