/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.datagen;

import chanceCubes.listeners.WorldGen;
import chanceCubes.modifier.AddCCubesFeaturesBiomeModifier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class CCubesBiomeModifiers {
    public static ResourceKey<BiomeModifier> CC_SURFACE = CCubesBiomeModifiers.createKey("chance_cube_worldgen");
    public static ResourceKey<BiomeModifier> CC_ORE = CCubesBiomeModifiers.createKey("chance_cube_oregen");

    private static ResourceKey<BiomeModifier> createKey(String id) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)id));
    }

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        HolderGetter placedGetter = context.lookup(Registries.PLACED_FEATURE);
        context.register(CC_SURFACE, (Object)new AddCCubesFeaturesBiomeModifier(0, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(WorldGen.CC_SURFACE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        context.register(CC_ORE, (Object)new AddCCubesFeaturesBiomeModifier(1, (HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(WorldGen.CC_ORE)}), GenerationStep.Decoration.UNDERGROUND_ORES));
    }
}

