/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemOfDestinyReward
extends BaseCustomReward {
    public ItemOfDestinyReward() {
        super("chancecubes:item_of_destiny", 40);
    }

    @Override
    public void trigger(final ServerLevel world, BlockPos pos, final Player player, JsonObject settings) {
        final ItemEntity item = new ItemEntity((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)RewardsUtil.getRandomItem(), 1));
        item.setPickUpDelay(100000);
        world.addFreshEntity((Entity)item);
        RewardsUtil.sendMessageToPlayer(player, "Selecting random item");
        Scheduler.scheduleTask(new Task(this, "Item_Of_Destiny_Reward", -1, 5){
            int iteration;
            int enchants;
            {
                super(name, delay, updateTick);
                this.iteration = 0;
                this.enchants = 0;
            }

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (this.iteration < 17) {
                    item.setItem(new ItemStack((ItemLike)RewardsUtil.getRandomItem(), 1));
                } else if (this.iteration == 17) {
                    RewardsUtil.sendMessageToPlayer(player, "Random item selected");
                    RewardsUtil.sendMessageToPlayer(player, "Selecting number of enchants to give item");
                } else if (this.iteration == 27) {
                    int i = RewardsUtil.rand.nextInt(9);
                    this.enchants = i < 5 ? 1 : (i < 8 ? 2 : 3);
                    RewardsUtil.sendMessageToPlayer(player, this.enchants + " random enchants will be added!");
                    RewardsUtil.sendMessageToPlayer(player, "Selecting random enchant to give to the item");
                } else if (this.iteration > 27 && (this.iteration - 7) % 10 == 0) {
                    if (this.iteration / 10 - 3 < this.enchants) {
                        CustomEntry<Holder<Enchantment>, Integer> ench = RewardsUtil.getRandomEnchantmentAndLevel((HolderLookup.Provider)world.registryAccess());
                        item.getItem().enchant(ench.getKey(), ench.getValue().intValue());
                        RewardsUtil.sendMessageToPlayer(player, (Component)ComponentWrapper.string(Language.getInstance().getOrDefault(((Enchantment)ench.getKey().value()).description().getString()) + " Has been added to the item!"));
                    } else {
                        RewardsUtil.sendMessageToPlayer(player, "Your item of destiny is complete! Enjoy!");
                        item.setPickUpDelay(0);
                        Scheduler.removeTask(this);
                    }
                }
                ++this.iteration;
            }
        });
    }
}

