/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.mcwrapper.EntityWrapper;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class WitherReward
extends BaseCustomReward {
    public WitherReward() {
        super("chancecubes:wither", -100);
    }

    @Override
    public void trigger(final ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
        final int isReal = super.getSettingAsInt(settings, "isReal", 10, 0, 100);
        final WitherBoss wither = (WitherBoss)EntityWrapper.spawnEntityAt(EntityType.WITHER, (Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 1.5);
        wither.makeInvulnerable();
        if (RewardsUtil.rand.nextBoolean()) {
            wither.setCustomName((Component)ComponentWrapper.string("Kiwi"));
        } else {
            wither.setCustomName((Component)ComponentWrapper.string("Kehaan"));
        }
        RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 32, "\"You've got to ask yourself one question: 'Do I feel lucky?' Well, do ya, punk?\"");
        Scheduler.scheduleTask(new Task(this, "Wither Reward", 180){

            @Override
            public void callback() {
                if (!this.removeEnts((Entity)wither)) {
                    RewardsUtil.executeCommand(level, player, (Vec3i)player.getOnPos(), "/advancement grant @p only chancecubes:wither");
                }
            }

            private boolean removeEnts(Entity ent) {
                if (RewardsUtil.rand.nextInt(100) > isReal) {
                    ent.remove(Entity.RemovalReason.DISCARDED);
                    return true;
                }
                return false;
            }
        });
    }
}

