/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen.widget;

import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.octostudios.octolib.client.screen.widget.Child;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.FakePinWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.GearMechanismWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.RotatingParent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class LockPinWidget
extends AbstractWidget
implements Child<RotatingParent> {
    public static final ResourceLocation ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"clavis", (String)"textures/minigame/gear/pin_active.png");
    public static final ResourceLocation INACTIVE = ResourceLocation.fromNamespaceAndPath((String)"clavis", (String)"textures/minigame/gear/pin_inactive.png");
    RotatingParent parent;
    public boolean active;
    private float yScale = 1.0f;
    Tween tween = Tween.create();

    public LockPinWidget(int x, int y) {
        super(x, y, 12, 36, (Component)Component.empty());
    }

    public static RotatingParent<LockPinWidget, GearMechanismWidget> create(int x, int y, float degrees, GearMechanismWidget parent) {
        RotatingParent rotatingParent = new RotatingParent(x, y, degrees, (Child[])new LockPinWidget[]{new LockPinWidget(-6, 38)});
        rotatingParent.setParent(parent);
        return rotatingParent;
    }

    public static RotatingParent<LockPinWidget, GearMechanismWidget> createFake(int x, int y, GearMechanismWidget parent) {
        RotatingParent rotatingParent = new RotatingParent(x, y, 0.0f, (Child[])new LockPinWidget[]{new FakePinWidget(-6, 38)});
        rotatingParent.setParent(parent);
        return rotatingParent;
    }

    public void disappear() {
        this.tween.kill();
        this.tween = Tween.create();
        this.tween.tweenMethod(this::setYScale, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f), (double)0.66f).setTransitionType(TransitionType.BACK).setEaseType(EaseType.EASE_IN);
        this.tween.start();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)(this.getY() + this.height), 0.0f);
        guiGraphics.pose().scale(1.0f, this.yScale, 1.0f);
        guiGraphics.blit(this.active ? this.getActiveTexture() : this.getInactiveTexture(), 0, -this.height, 12, 36, 0.0f, 0.0f, 12, 36, 12, 36);
        guiGraphics.pose().popPose();
    }

    public ResourceLocation getActiveTexture() {
        return ACTIVE;
    }

    public ResourceLocation getInactiveTexture() {
        return INACTIVE;
    }

    @Nullable
    public RotatingParent getParent() {
        return this.parent;
    }

    public void setParent(@Nullable RotatingParent parent) {
        this.parent = parent;
    }

    public boolean activate() {
        if (this.active) {
            return false;
        }
        this.active = true;
        this.animateActivation();
        return true;
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.animateDectivation();
    }

    private void animateActivation() {
        this.tween.kill();
        this.tween = Tween.create();
        this.tween.tweenMethod(this::setYScale, (Object)Float.valueOf(1.384f), (Object)Float.valueOf(1.0f), 0.5).setTransitionType(TransitionType.ELASTIC).setEaseType(EaseType.EASE_OUT);
        this.tween.start();
    }

    private void animateDectivation() {
        this.tween.kill();
        this.tween = Tween.create();
        this.tween.tweenMethod(this::setYScale, (Object)Float.valueOf(0.722f), (Object)Float.valueOf(1.0f), 0.5).setTransitionType(TransitionType.ELASTIC).setEaseType(EaseType.EASE_OUT);
        this.tween.start();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public void onClick(double mouseX, double mouseY) {
        super.onClick(mouseX, mouseY);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setYScale(float yScale) {
        this.yScale = yScale;
    }
}

