/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import it.hurts.octostudios.octolib.OctoLib;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.client.render.LockWorldRenderer;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.network.packet.AddLockPacket;
import it.hurts.shatterbyte.clavis.common.network.packet.RemoveLockPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ClavisSavedData
extends SavedData {
    private static final String DATA_NAME = "clavis_locks";
    public static final SavedData.Factory<ClavisSavedData> FACTORY = new SavedData.Factory(ClavisSavedData::new, ClavisSavedData::load, null);
    private final CompoundTag dataTag = new CompoundTag();
    private final Set<Lock> locks = new HashSet<Lock>();
    private final Multimap<ChunkPos, Lock> lockLookupMap = HashMultimap.create();

    public static ClavisSavedData get(ServerLevel level) {
        return (ClavisSavedData)level.getDataStorage().computeIfAbsent(FACTORY, DATA_NAME);
    }

    private ClavisSavedData() {
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.merge(this.dataTag);
        DataResult result = Lock.SET_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.locks);
        result.resultOrPartial(arg_0 -> ((Logger)OctoLib.LOGGER).warn(arg_0)).ifPresent(encodedTag -> tag.put("Locks", encodedTag));
        return tag;
    }

    private static ClavisSavedData load(CompoundTag tag, HolderLookup.Provider registries) {
        ClavisSavedData data = new ClavisSavedData();
        data.dataTag.merge(tag);
        if (tag.contains("Locks", 9)) {
            DataResult result = Lock.SET_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("Locks"));
            result.resultOrPartial(arg_0 -> ((Logger)OctoLib.LOGGER).warn(arg_0)).ifPresent(list -> {
                data.locks.addAll((Collection<Lock>)list);
                list.forEach(data::indexLock);
            });
        }
        return data;
    }

    private void indexLock(Lock lock) {
        int minChunkX = lock.box.minX >> 4;
        int maxChunkX = lock.box.maxX >> 4;
        int minChunkZ = lock.box.minZ >> 4;
        int maxChunkZ = lock.box.maxZ >> 4;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                this.lockLookupMap.put((Object)new ChunkPos(cx, cz), (Object)lock);
            }
        }
    }

    public void addLock(Lock lock, ServerLevel level) {
        this.locks.add(lock);
        int minChunkX = lock.box.minX >> 4;
        int maxChunkX = lock.box.maxX >> 4;
        int minChunkZ = lock.box.minZ >> 4;
        int maxChunkZ = lock.box.maxZ >> 4;
        HashSet toSend = new HashSet();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            int cz = minChunkZ;
            while (cz <= maxChunkZ) {
                this.lockLookupMap.put((Object)new ChunkPos(cx, cz), (Object)lock);
                int finalCx = cx;
                int finalCz = cz++;
                toSend.addAll(level.getPlayers(player -> player.getChunkTrackingView().contains(finalCx, finalCz)));
            }
        }
        if (!Clavis.CONFIG.isDisableLockRendering()) {
            NetworkManager.sendToPlayers(toSend, (CustomPacketPayload)new AddLockPacket(lock));
        }
        this.setDirty();
    }

    public void removeLock(Lock lock, ServerLevel level) {
        this.locks.remove(lock);
        int minChunkX = lock.box.minX >> 4;
        int maxChunkX = lock.box.maxX >> 4;
        int minChunkZ = lock.box.minZ >> 4;
        int maxChunkZ = lock.box.maxZ >> 4;
        HashSet toSend = new HashSet();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            int cz = minChunkZ;
            while (cz <= maxChunkZ) {
                this.lockLookupMap.remove((Object)new ChunkPos(cx, cz), (Object)lock);
                int finalCx = cx;
                int finalCz = cz++;
                toSend.addAll(level.getPlayers(player -> player.getChunkTrackingView().contains(finalCx, finalCz)));
            }
        }
        NetworkManager.sendToPlayers(toSend, (CustomPacketPayload)new RemoveLockPacket(lock));
        this.setDirty();
    }

    public List<Lock> getLocksAt(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        return new ArrayList<Lock>(this.lockLookupMap.get((Object)chunkPos).stream().filter(lock -> lock.box.isInside((Vec3i)pos)).toList());
    }

    public List<Lock> getLocksAt(ChunkPos chunkPos) {
        return new ArrayList<Lock>(this.lockLookupMap.get((Object)chunkPos));
    }

    public static boolean isLocked(BlockPos pos, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClavisSavedData data = ClavisSavedData.get(serverLevel);
            return !data.getLocksAt(pos).isEmpty();
        }
        return LockWorldRenderer.FOR_RENDERING.stream().anyMatch(lock -> lock.getBox().isInside((Vec3i)pos));
    }
}

