/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.network;

import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.value.IntValue;
import it.hurts.shatterbyte.clavis.common.LockManager;
import it.hurts.shatterbyte.clavis.common.network.packet.CheckIfLockedPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class LockInteractionBlockers {
    public static EventResult onBreak(Level level, BlockPos pos, BlockState blockState, ServerPlayer serverPlayer, @Nullable IntValue intValue) {
        if (serverPlayer.isCreative() && serverPlayer.isCrouching() || serverPlayer.isSpectator()) {
            return EventResult.pass();
        }
        if (LockManager.isLocked(level, (Player)serverPlayer, pos)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static void onBlow(Level level, Explosion explosion, List<Entity> entities) {
        if (level.isClientSide()) {
            return;
        }
        ArrayList toNotBlow = new ArrayList();
        explosion.getToBlow().forEach(pos -> {
            if (!LockManager.getLocksAt((ServerLevel)level, null, pos).isEmpty()) {
                toNotBlow.add(pos);
            }
        });
        explosion.getToBlow().removeAll(toNotBlow);
    }

    public static EventResult onInteract(Player player, InteractionHand interactionHand, BlockPos pos, Direction direction) {
        if (player.isCreative() && player.isCrouching() || player.isSpectator()) {
            return EventResult.pass();
        }
        if (player.level().isClientSide()) {
            NetworkManager.sendToServer((CustomPacketPayload)new CheckIfLockedPacket(pos, interactionHand));
        }
        return LockInteractionBlockers.cancelInteraction(player, interactionHand, pos, direction);
    }

    public static EventResult cancelInteraction(Player player, InteractionHand interactionHand, BlockPos pos, Direction direction) {
        if (player.isCreative() && player.isCrouching() || player.isSpectator()) {
            return EventResult.pass();
        }
        if (LockManager.isLocked(player.level(), player, pos)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

