/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib;

import codechicken.lib.gui.modular.lib.GuiRender;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public interface TooltipHandler<T extends TooltipHandler<T>> {
    public Supplier<List<Component>> getTooltip();

    public T setTooltipDelay(int var1);

    public int getTooltipDelay();

    default public T setTooltipSingle(@Nullable Component Tooltip) {
        return this.setTooltip(Tooltip == null ? null : () -> Collections.singletonList(Tooltip));
    }

    default public T setTooltip(Component ... Tooltip) {
        return this.setTooltip(Tooltip == null ? null : () -> List.of(Tooltip));
    }

    default public T setTooltipSingle(@Nullable Supplier<Component> tooltip) {
        return this.setTooltip(tooltip == null ? null : () -> Collections.singletonList((Component)tooltip.get()));
    }

    default public T setTooltip(@Nullable List<Component> tooltip) {
        return this.setTooltip(tooltip == null ? null : () -> tooltip);
    }

    public T setTooltip(@Nullable Supplier<List<Component>> var1);

    default public T setTooltip(@Nullable Supplier<List<Component>> tooltip, int tooltipDelay) {
        this.setTooltip(tooltip);
        this.setTooltipDelay(tooltipDelay);
        return (T)((TooltipHandler)SneakyUtils.unsafeCast((Object)this));
    }

    default public boolean renderTooltip(GuiRender render, double mouseX, double mouseY) {
        Supplier<List<Component>> supplier = this.getTooltip();
        if (supplier == null) {
            return false;
        }
        List<Component> list = supplier.get();
        if (list.isEmpty()) {
            return false;
        }
        render.componentTooltip(list.stream().flatMap(component -> render.font().getSplitter().splitLines((FormattedText)component, Integer.MAX_VALUE, component.getStyle()).stream()).toList(), mouseX, mouseY);
        return true;
    }
}

