/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.gui;

import com.cyanogen.cognition.registries.RegisterMenus;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class MolecularMetamorpherMenu
extends AbstractContainerMenu {
    SimpleContainer container = new SimpleContainer(5);
    private ContainerData blockPositionData;
    public Inventory inventory;
    Component component = Component.literal((String)"Molecular Metamorpher");

    public MolecularMetamorpherMenu(int id, Inventory inventory) {
        this(id, inventory, null, null, null);
        this.inventory = inventory;
        this.blockPositionData = new SimpleContainerData(3);
        this.addDataSlots(this.blockPositionData);
    }

    public MolecularMetamorpherMenu(int id, Inventory inventory, IItemHandler inputs, IItemHandler output, @Nullable BlockPos pos) {
        super((MenuType)RegisterMenus.MOLECULAR_METAMORPHER_MENU.get(), id);
        if (pos != null) {
            this.blockPositionData = new SimpleContainerData(3);
            this.blockPositionData.set(0, pos.getX());
            this.blockPositionData.set(1, pos.getY());
            this.blockPositionData.set(2, pos.getZ());
            this.addDataSlots(this.blockPositionData);
            this.sendAllDataToRemote();
        } else {
            this.blockPositionData = new SimpleContainerData(3);
        }
        if (inputs != null && output != null) {
            this.addSlot((Slot)new SlotItemHandler(inputs, 0, 19, 35));
            this.addSlot((Slot)new SlotItemHandler(inputs, 1, 50, 52));
            this.addSlot((Slot)new SlotItemHandler(inputs, 2, 70, 18));
            this.addSlot((Slot)new SlotItemHandler(this, output, 0, 140, 35){

                public boolean mayPlace(ItemStack stack) {
                    return false;
                }
            });
        } else {
            this.addSlot(new Slot((Container)this.container, 0, 19, 35));
            this.addSlot(new Slot((Container)this.container, 1, 50, 52));
            this.addSlot(new Slot((Container)this.container, 2, 70, 18));
            this.addSlot(new Slot(this, (Container)this.container, 3, 140, 35){

                public boolean mayPlace(ItemStack stack) {
                    return false;
                }
            });
        }
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    public int put(ItemStack stack, int amount) {
        int transferredCount = 0;
        if (stack.getCount() < amount) {
            amount = stack.getCount();
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack copy = stack.copy();
            copy.setCount(amount);
            Slot slot = this.getSlot(i);
            if (!slot.hasItem()) {
                this.getSlot(i).set(copy);
                stack.shrink(amount);
                this.broadcastChanges();
                return amount;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)copy)) continue;
            int grow = Math.min(amount, slot.getItem().getMaxStackSize() - slot.getItem().getCount());
            slot.getItem().grow(grow);
            stack.shrink(grow);
            this.broadcastChanges();
            return grow;
        }
        return transferredCount;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.blockPositionData.get(0), this.blockPositionData.get(1), this.blockPositionData.get(2));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index <= 3 ? !this.moveItemStackTo(itemstack1, 4, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 3, true)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return player.position().distanceTo(Vec3.atCenterOf((Vec3i)this.getBlockPos())) <= 7.0;
    }
}

