/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.utils.ItemUtils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class ActivatableItem
extends Item {
    public ActivatableItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("isActive", false);
        ItemUtils.saveCustomDataTag(stack, tag);
        return stack;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public boolean isFoil(ItemStack stack) {
        return ItemUtils.getCustomDataTag(stack).getBoolean("isActive");
    }

    public void playActivationSound(Player player) {
    }

    public void playDeactivationSound(Player player) {
    }

    public boolean isActive(ItemStack stack) {
        CompoundTag tag = ItemUtils.getCustomDataTag(stack);
        return tag.getBoolean("isActive");
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        CompoundTag tag = ItemUtils.getCustomDataTag(stack);
        if (player.isShiftKeyDown()) {
            boolean isActive = tag.getBoolean("isActive");
            if (isActive) {
                tag.putBoolean("isActive", false);
                this.playDeactivationSound(player);
            } else {
                tag.putBoolean("isActive", true);
                this.playActivationSound(player);
            }
            ItemUtils.saveCustomDataTag(stack, tag);
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        boolean isActive = ItemUtils.getCustomDataTag(stack).getBoolean("isActive");
        if (isActive) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.cognition.activatable_item.active"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.cognition.activatable_item.inactive"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

