/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.network.experience_obelisk;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UpdateRadius
implements CustomPacketPayload {
    public final int posX;
    public final int posY;
    public final int posZ;
    public final double changeInRadius;
    public static final StreamCodec<ByteBuf, UpdateRadius> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, UpdateRadius::getPosX, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateRadius::getPosY, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateRadius::getPosZ, (StreamCodec)ByteBufCodecs.DOUBLE, UpdateRadius::getChangeInRadius, UpdateRadius::new);
    public static final CustomPacketPayload.Type<UpdateRadius> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"experience_obelisk_update_radius"));

    public UpdateRadius(@Nullable BlockPos pos, double changeInRadius) {
        if (pos == null) {
            this.posX = 0;
            this.posY = 0;
            this.posZ = 0;
        } else {
            this.posX = pos.getX();
            this.posY = pos.getY();
            this.posZ = pos.getZ();
        }
        this.changeInRadius = changeInRadius;
    }

    public UpdateRadius(int posX, int posY, int posZ, double changeInRadius) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.changeInRadius = changeInRadius;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public double getChangeInRadius() {
        return this.changeInRadius;
    }

    public static void handleServer(UpdateRadius packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player;
            BlockEntity entity;
            if (!context.player().level().isClientSide && (entity = (player = (ServerPlayer)context.player()).level().getBlockEntity(new BlockPos(packet.posX, packet.posY, packet.posZ))) instanceof ExperienceObeliskEntity) {
                ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)entity;
                double finalRadius = obelisk.getRadius() + packet.changeInRadius;
                if (packet.changeInRadius == 0.0) {
                    obelisk.setRadius(2.5);
                } else if (finalRadius >= 1.0 && finalRadius <= 5.0) {
                    obelisk.setRadius(finalRadius);
                }
            }
        });
    }
}

