/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei;

import com.cyanogen.cognition.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.cognition.registries.RegisterItems;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.cyanogen.cognition.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MolecularMetamorpherCategory
implements IRecipeCategory<MolecularMetamorpherRecipe> {
    IRecipeCategoryRegistration registration;
    IGuiHelper guiHelper;
    private final ResourceLocation texture = ResourceLocation.parse((String)"cognition:textures/gui/recipes/molecular_metamorpher_jei.png");
    private final IDrawableAnimated arrow;
    public static final RecipeType<MolecularMetamorpherRecipe> METAMORPHER_TYPE = RecipeType.create((String)"cognition", (String)"molecular_metamorphosis", MolecularMetamorpherRecipe.class);

    public MolecularMetamorpherCategory(IRecipeCategoryRegistration registration) {
        this.registration = registration;
        this.guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.arrow = this.guiHelper.drawableBuilder(this.texture, 0, 87, 29, 5).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<MolecularMetamorpherRecipe> getRecipeType() {
        return METAMORPHER_TYPE;
    }

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 87;
    }

    public Component getTitle() {
        return Component.translatable((String)"title.cognition.molecular_metamorpher");
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.MOLECULAR_METAMORPHER_ITEM.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    public void draw(MolecularMetamorpherRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.guiHelper.createDrawable(this.texture, 0, 0, 176, 87).draw(guiGraphics);
        this.arrow.draw(guiGraphics, 108, 47);
        Font font = Minecraft.getInstance().font;
        int cost = recipe.getCost();
        int levelCost = ExperienceUtils.xpToLevels(cost);
        int xpBarLength = 61;
        double progress = ExperienceUtils.getProgressToNextLevel(cost, levelCost);
        if (progress == 0.0) {
            progress = 1.0;
        }
        guiGraphics.blit(this.texture, this.getWidth() - 66, this.getHeight() - 12, 0, 92, (int)((double)xpBarLength * progress) + 2, 10);
        guiGraphics.drawCenteredString(font, (Component)Component.literal((String)String.valueOf(levelCost)).withStyle(ChatFormatting.GREEN), this.getWidth() - 31, this.getHeight() - 11, 0xFFFFFF);
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public void getTooltip(ITooltipBuilder tooltip, MolecularMetamorpherRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int cost = recipe.getCost();
        int time = recipe.getProcessTime() / 20;
        MutableComponent c2 = Component.literal((String)String.valueOf(cost)).withStyle(ChatFormatting.GREEN);
        MutableComponent c3 = Component.literal((String)(time + "s")).withStyle(ChatFormatting.GOLD);
        MutableComponent costXP = Component.translatable((String)"jei.cognition.metamorpher.cost_xp", (Object[])new Object[]{c2});
        MutableComponent processTime = Component.translatable((String)"jei.cognition.metamorpher.process_time", (Object[])new Object[]{c3});
        int x1 = this.getWidth() - 67;
        int x2 = this.getWidth();
        int y1 = this.getHeight() - 14;
        int y2 = this.getHeight();
        if (mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            tooltip.add((FormattedText)costXP);
            tooltip.add((FormattedText)processTime);
        }
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MolecularMetamorpherRecipe recipe, IFocusGroup focuses) {
        if (!recipe.getId().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"item_name_formatting"))) {
            builder.setShapeless();
            this.setJsonRecipe(builder, recipe);
        } else {
            this.setNameFormattingRecipe(builder);
        }
    }

    public void setJsonRecipe(IRecipeLayoutBuilder builder, MolecularMetamorpherRecipe recipe) {
        int[] x = new int[]{19, 50, 70};
        int[] y = new int[]{35, 52, 18};
        for (int i = 1; i <= 3; ++i) {
            Ingredient ingredient = (Ingredient)recipe.getIngredients(true).get(i).getA();
            int count = (Integer)recipe.getIngredients(true).get(i).getB();
            builder.addSlot(RecipeIngredientRole.INPUT, x[i - 1], y[i - 1]).setSlotName("input" + i).addItemStacks(RecipeUtils.getItemListWithCounts(ingredient, count));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 140, 35).setSlotName("output").addItemStack(recipe.getResultItem(null));
    }

    public void setNameFormattingRecipe(IRecipeLayoutBuilder builder) {
        ItemStack outputItem;
        ChatFormatting format;
        List<ItemStack> formatItemList = RecipeUtils.convertItemListToItemStackList(RecipeUtils.getValidDyes());
        formatItemList.addAll(RecipeUtils.convertItemListToItemStackList(RecipeUtils.getValidFormattingItems()));
        ItemStack inputItem = new ItemStack((ItemLike)RegisterItems.DUMMY_SWORD.get(), 1).copy();
        inputItem.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"jei.cognition.name.any_item"));
        Ingredient formatItems = Ingredient.of(formatItemList.stream());
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        for (Item dye : RecipeUtils.getValidDyes()) {
            if (!(dye instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)dye;
            int dyeColor = dyeItem.getDyeColor().getId();
            format = ChatFormatting.getById((int)RecipeUtils.dyeColorToTextColor(dyeColor));
            assert (format != null);
            outputItem = inputItem.copy();
            outputItem.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"jei.cognition.name.any_item").withStyle(format));
            outputItems.add(outputItem);
        }
        for (Item formattingItem : RecipeUtils.getValidFormattingItems()) {
            int index = RecipeUtils.getValidFormattingItems().indexOf(formattingItem);
            char code = RecipeUtils.itemToFormat(index);
            format = ChatFormatting.getByCode((char)code);
            assert (format != null);
            outputItem = inputItem.copy();
            outputItem.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"jei.cognition.name.any_item").withStyle(format));
            outputItems.add(outputItem);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 35).setSlotName("input1").addItemStack(inputItem);
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 52).setSlotName("input2").addItemStack(Items.NAME_TAG.getDefaultInstance());
        builder.addSlot(RecipeIngredientRole.INPUT, 70, 18).setSlotName("input3").addIngredients(formatItems);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 140, 35).setSlotName("output").addItemStacks(outputItems);
    }
}

