/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.basics.option;

import com.google.common.base.Enums;
import mrbysco.constructionstick.basics.option.IOption;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class OptionEnum<E extends Enum<E>>
implements IOption<E> {
    private final ItemStack stack;
    private final DataComponentType<E> componentType;
    private final String key;
    private final Class<E> enumClass;
    private final boolean enabled;
    private final E dval;
    private E value;

    public OptionEnum(ItemStack stack, DataComponentType<E> componentType, String key, Class<E> enumClass, E dval, boolean enabled) {
        this.stack = stack;
        this.componentType = componentType;
        this.key = key;
        this.enumClass = enumClass;
        this.enabled = enabled;
        this.dval = dval;
        this.value = (Enum)stack.getOrDefault(componentType, dval);
    }

    public OptionEnum(ItemStack stack, DataComponentType<E> componentType, String key, Class<E> enumClass, E dval) {
        this(stack, componentType, key, enumClass, dval, true);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public DataComponentType<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public String getValueString() {
        return ((Enum)this.value).name().toLowerCase();
    }

    @Override
    public void setValueString(String val) {
        this.set((E)((Enum)Enums.getIfPresent(this.enumClass, (String)val.toUpperCase()).or(this.dval)));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void set(E val) {
        if (!this.enabled) {
            return;
        }
        this.value = val;
        this.stack.set(this.componentType, val);
    }

    @Override
    public E get() {
        return this.value;
    }

    @Override
    public E next(boolean dir) {
        Enum[] enumValues = (Enum[])this.enumClass.getEnumConstants();
        int i = ((Enum)this.value).ordinal() + (dir ? 1 : -1);
        if (i < 0) {
            i += enumValues.length;
        }
        this.set((E)enumValues[i % enumValues.length]);
        return this.value;
    }
}

