/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.client.render;

import com.blakebr0.cucumber.client.ModRenderTypes;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.MatrixUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public final class GhostItemRenderer {
    public static void renderItemIntoGui(ItemStack stack, int x, int y, ItemRenderer itemRenderer) {
        GhostItemRenderer.renderItemModelIntoGUI(stack, x, y, itemRenderer.getModel(stack, null, null, 0), itemRenderer);
    }

    private static void renderItem(ItemStack itemStackIn, ItemDisplayContext transformTypeIn, boolean leftHand, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BakedModel modelIn, ItemRenderer itemRenderer) {
        if (!itemStackIn.isEmpty()) {
            boolean flag;
            matrixStackIn.pushPose();
            boolean bl = flag = transformTypeIn == ItemDisplayContext.GUI || transformTypeIn == ItemDisplayContext.GROUND || transformTypeIn == ItemDisplayContext.FIXED;
            if (flag) {
                if (itemStackIn.is(Items.TRIDENT)) {
                    modelIn = itemRenderer.getItemModelShaper().getModelManager().getModel(ModelResourceLocation.vanilla((String)"trident", (String)"#inventory"));
                } else if (itemStackIn.is(Items.SPYGLASS)) {
                    modelIn = itemRenderer.getItemModelShaper().getModelManager().getModel(ModelResourceLocation.vanilla((String)"spyglass", (String)"inventory"));
                }
            }
            modelIn = ClientHooks.handleCameraTransforms((PoseStack)matrixStackIn, (BakedModel)modelIn, (ItemDisplayContext)transformTypeIn, (boolean)leftHand);
            matrixStackIn.translate(-0.5f, -0.5f, -0.5f);
            if (!(modelIn.isCustomRenderer() || itemStackIn.is(Items.TRIDENT) && !flag)) {
                BlockItem blockitem;
                Block block;
                Item item;
                boolean flag1 = transformTypeIn != ItemDisplayContext.GUI && !transformTypeIn.firstPerson() && (item = itemStackIn.getItem()) instanceof BlockItem ? !((block = (blockitem = (BlockItem)item).getBlock()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                for (BakedModel model : modelIn.getRenderPasses(itemStackIn, flag1)) {
                    for (RenderType rendertype : model.getRenderTypes(itemStackIn, flag1)) {
                        VertexConsumer vertexconsumer;
                        rendertype = ModRenderTypes.GHOST;
                        if (GhostItemRenderer.hasAnimatedTexture(itemStackIn) && itemStackIn.hasFoil()) {
                            PoseStack.Pose posestack$pose = matrixStackIn.last().copy();
                            if (transformTypeIn == ItemDisplayContext.GUI) {
                                MatrixUtil.mulComponentWise((Matrix4f)posestack$pose.pose(), (float)0.5f);
                            } else if (transformTypeIn.firstPerson()) {
                                MatrixUtil.mulComponentWise((Matrix4f)posestack$pose.pose(), (float)0.75f);
                            }
                            vertexconsumer = ItemRenderer.getCompassFoilBuffer((MultiBufferSource)bufferIn, (RenderType)rendertype, (PoseStack.Pose)posestack$pose);
                        } else {
                            vertexconsumer = flag1 ? ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.hasFoil()) : ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.hasFoil());
                        }
                        itemRenderer.renderModelLists(model, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, vertexconsumer);
                    }
                }
            } else {
                IClientItemExtensions.of((ItemStack)itemStackIn).getCustomRenderer().renderByItem(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.popPose();
        }
    }

    private static boolean hasAnimatedTexture(ItemStack p_286353_) {
        return p_286353_.is(ItemTags.COMPASSES) || p_286353_.is(Items.CLOCK);
    }

    private static void renderItemModelIntoGUI(ItemStack stack, int x, int y, BakedModel bakedmodel, ItemRenderer itemRenderer) {
        boolean flag;
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        posestack.translate((float)x, (float)y, 100.0f);
        posestack.translate(8.0f, 8.0f, 0.0f);
        posestack.mul((Matrix4fc)new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        posestack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flag = !bakedmodel.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        GhostItemRenderer.renderItem(stack, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel, itemRenderer);
        multibuffersource$buffersource.endBatch();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }
}

