/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.common.util.LRU;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class BaseScreen
extends Screen {
    private static final ResourceLocation BLANK_BACKGROUND = CustomMachinery.rl("background");
    public final Minecraft mc = Minecraft.getInstance();
    public int x;
    public int y;
    public int xSize;
    public int ySize;
    private final LRU<PopupScreen> popups = new LRU();
    private final Map<PopupScreen, String> popupToId = new HashMap<PopupScreen, String>();
    private int freezePopupsTicks;

    public BaseScreen(Component component, int xSize, int ySize) {
        super(component);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public void openPopup(PopupScreen popup) {
        if (this.popups.contains((Object)popup)) {
            return;
        }
        this.setFocused(null);
        this.popups.add(popup);
        popup.init(Minecraft.getInstance(), this.width, this.height);
    }

    public void openPopup(PopupScreen popup, String id) {
        if (this.popupToId.containsValue(id)) {
            return;
        }
        this.popupToId.put(popup, id);
        this.openPopup(popup);
        this.freezePopupsTicks = 40;
    }

    public void closePopup(PopupScreen popup) {
        popup.closed();
        this.popups.remove((Object)popup);
        this.popupToId.remove((Object)popup);
    }

    public LRU<PopupScreen> popups() {
        return this.popups;
    }

    @Nullable
    public PopupScreen getPopupUnderMouse(double mouseX, double mouseY) {
        return this.popups.stream().filter(popup -> mouseX >= (double)popup.x && mouseX <= (double)(popup.x + popup.xSize) && mouseY >= (double)popup.y && mouseY <= (double)(popup.y + popup.ySize)).findFirst().orElse(null);
    }

    public void removed() {
        this.popups.forEach(PopupScreen::closed);
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        return (T)super.addRenderableWidget(widget);
    }

    public void removeWidget(GuiEventListener listener) {
        super.removeWidget(listener);
    }

    protected void init() {
        this.x = (this.width - this.xSize) / 2;
        this.y = (this.height - this.ySize) / 2;
        this.popups.forEach(popup -> popup.init(Minecraft.getInstance(), this.width, this.height));
    }

    public void tick() {
        this.popups.forEach(BaseScreen::tick);
        if (this.freezePopupsTicks > 0) {
            --this.freezePopupsTicks;
        }
    }

    public void resize(Minecraft minecraft, int width, int height) {
        this.x = (width - this.xSize) / 2;
        this.y = (height - this.ySize) / 2;
        super.resize(minecraft, width, height);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        PopupScreen hoveredPopup = this.getPopupUnderMouse(mouseX, mouseY);
        graphics.pose().pushPose();
        if (hoveredPopup != null) {
            super.render(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
        } else {
            super.render(graphics, mouseX, mouseY, partialTicks);
        }
        LRU.LRUIterator iterator = this.popups.descendingIterator();
        while (iterator.hasNext()) {
            graphics.pose().translate(0.0f, 0.0f, 165.0f);
            PopupScreen popup = (PopupScreen)((Object)iterator.next());
            if (hoveredPopup == popup) {
                popup.renderWithTooltip(graphics, mouseX, mouseY, partialTicks);
                continue;
            }
            popup.render(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
        }
        graphics.pose().popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (PopupScreen popup : this.popups) {
            if (!popup.isMouseOver(mouseX, mouseY)) continue;
            boolean clicked = popup.mouseClicked(mouseX, mouseY, button);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popup);
            }
            return clicked;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (PopupScreen popup : this.popups) {
            if (!popup.isMouseOver(mouseX, mouseY)) continue;
            boolean released = popup.mouseReleased(mouseX, mouseY, button);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popup);
            }
            return released;
        }
        this.setDragging(false);
        if (this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return this.getChildAt(mouseX, mouseY).filter(guiEventListener -> guiEventListener.mouseReleased(mouseX, mouseY, button)).isPresent();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        LRU.LRUIterator lRUIterator = this.popups.iterator();
        if (lRUIterator.hasNext()) {
            PopupScreen popup = (PopupScreen)((Object)lRUIterator.next());
            boolean dragged = popup.mouseDragged(mouseX, mouseY, button, dragX, dragY);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popup);
            }
            return dragged;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (PopupScreen popup : this.popups) {
            if (!popup.isMouseOver(mouseX, mouseY)) continue;
            boolean scrolled = popup.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popup);
            }
            return scrolled;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        FocusNavigationEvent.ArrowNavigation event;
        if (keyCode == 256) {
            if (!this.popups.isEmpty()) {
                PopupScreen toClose = this.getPopupUnderMouse(Minecraft.getInstance().mouseHandler.xpos(), Minecraft.getInstance().mouseHandler.ypos());
                if (toClose == null) {
                    toClose = (PopupScreen)((Object)this.popups.iterator().next());
                }
                this.closePopup(toClose);
                return true;
            }
            if (this.getFocused() != null && this.getFocused().keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            this.onClose();
            return true;
        }
        for (PopupScreen popup : this.popups) {
            if (!popup.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (this.getFocused() != null && this.getFocused().keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 263: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.LEFT);
                break;
            }
            case 262: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.RIGHT);
                break;
            }
            case 265: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.UP);
                break;
            }
            case 264: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.DOWN);
                break;
            }
            case 258: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.TabNavigation(!Screen.hasShiftDown());
                break;
            }
            default: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = event = null;
            }
        }
        if (event != null) {
            ComponentPath path = this.popups.stream().findFirst().map(arg_0 -> BaseScreen.lambda$keyPressed$3((FocusNavigationEvent)event, arg_0)).orElse(this.nextFocusPath((FocusNavigationEvent)event));
            if (path == null && event instanceof FocusNavigationEvent.TabNavigation) {
                ComponentPath componentPath = this.getCurrentFocusPath();
                if (componentPath != null) {
                    componentPath.applyFocus(false);
                }
                path = super.nextFocusPath((FocusNavigationEvent)event);
            }
            if (path != null) {
                this.changeFocus(path);
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (PopupScreen popup : this.popups) {
            if (!popup.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        for (PopupScreen popup : this.popups) {
            if (!popup.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.getPopupUnderMouse(mouseX, mouseY) != null) {
            return false;
        }
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.xSize) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.ySize);
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        if (this.getFocused() != focused) {
            super.setFocused(focused);
        }
        if (focused != null) {
            this.popups.forEach(popup -> popup.setFocused(null));
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static void blankBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.blitSprite(BLANK_BACKGROUND, x, y, width, height);
    }

    public static void drawCenteredScaledString(GuiGraphics graphics, Font font, Component text, int x, int y, float scale, int color, boolean shadow) {
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 0.0f);
        int n = (int)(((float)x - (float)font.width((FormattedText)text) * scale / 2.0f) / scale);
        Objects.requireNonNull(font);
        graphics.drawString(font, text, n, (int)((float)(y - 9 / 2) / scale), color, shadow);
        graphics.pose().popPose();
    }

    public static void drawScaledString(GuiGraphics graphics, Font font, Component text, int x, int y, float scale, int color, boolean shadow) {
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 0.0f);
        graphics.drawString(font, text, (int)((float)x / scale), (int)((float)y / scale), color, shadow);
        graphics.pose().popPose();
    }

    private static /* synthetic */ ComponentPath lambda$keyPressed$3(FocusNavigationEvent event, PopupScreen popup) {
        return popup.nextFocusPath(event);
    }
}

