/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation;

import fr.frinn.custommachinery.client.screen.CustomMachineScreen;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.joml.Matrix4f;

public record MachineTooltipComponent(CustomMachine machine) implements TooltipComponent
{

    public static class ClientMachineTooltipComponent
    implements ClientTooltipComponent {
        private final CustomMachine machine;
        private final CustomMachineScreen screen;

        public ClientMachineTooltipComponent(MachineTooltipComponent component) {
            this.machine = component.machine();
            if (Minecraft.getInstance().player == null) {
                throw new IllegalStateException();
            }
            Inventory playerInv = Minecraft.getInstance().player.getInventory();
            this.screen = new TemplateMachineScreen(this, new CustomMachineContainer(0, playerInv, new TemplateMachineTile()), playerInv, (Component)Component.empty());
            this.screen.init(Minecraft.getInstance(), Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight());
        }

        public int getHeight() {
            return this.screen.getYSize() / 2;
        }

        public int getWidth(Font font) {
            return this.screen.getXSize() / 2;
        }

        public void renderText(Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
            font.drawInBatch((Component)Component.empty(), (float)mouseX, (float)mouseY, -1, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }

        public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
            graphics.pose().pushPose();
            graphics.pose().scale(0.5f, 0.5f, 1.0f);
            graphics.pose().translate((float)(x * 2 - this.screen.getX()), (float)(y * 2 - this.screen.getY()), 0.0f);
            this.screen.render(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, 0.0f);
            graphics.pose().popPose();
        }

        private class TemplateMachineScreen
        extends CustomMachineScreen {
            public TemplateMachineScreen(ClientMachineTooltipComponent clientMachineTooltipComponent, CustomMachineContainer container, Inventory inv, Component name) {
                super(container, inv, name);
            }

            public void renderTransparentBackground(GuiGraphics graphics) {
            }
        }

        private class TemplateMachineTile
        extends CustomMachineTile {
            public TemplateMachineTile() {
                super(BlockPos.ZERO, ((CustomMachineBlock)((Object)Registration.CUSTOM_MACHINE_BLOCK.get())).defaultBlockState());
            }

            @Override
            public CustomMachine getMachine() {
                return ClientMachineTooltipComponent.this.machine;
            }
        }
    }
}

