/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.creation.component.MachineComponentBuilderRegistry;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.ListWidget;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;

public class ComponentCreationPopup
extends PopupScreen {
    public static final Component CONFIRM = Component.translatable((String)"custommachinery.gui.popup.confirm").withStyle(ChatFormatting.GREEN);
    public static final Component CANCEL = Component.translatable((String)"custommachinery.gui.popup.cancel").withStyle(ChatFormatting.RED);
    private final Runnable onChange;
    private ComponentCreationListWidget list;

    public ComponentCreationPopup(MachineEditScreen parent, Runnable onChange) {
        super(parent, 144, 164);
        this.onChange = onChange;
    }

    private void confirm() {
        BaseScreen baseScreen;
        ComponentCreationListWidget.ComponentCreationListEntry entry = (ComponentCreationListWidget.ComponentCreationListEntry)this.list.getSelected();
        if (entry != null && (baseScreen = this.parent) instanceof MachineEditScreen) {
            MachineEditScreen editScreen = (MachineEditScreen)baseScreen;
            PopupScreen componentCreationPopup = entry.builder.makePopup(editScreen, null, template -> {
                editScreen.getBuilder().getComponents().add((IMachineComponentTemplate<?>)template);
                editScreen.setChanged();
                this.onChange.run();
            });
            editScreen.closePopup(this);
            editScreen.openPopup(componentCreationPopup);
        }
    }

    private void cancel() {
        this.parent.closePopup(this);
    }

    @Override
    protected void init() {
        super.init();
        MutableComponent title = Component.translatable((String)"custommachinery.gui.creation.components.create.title");
        Objects.requireNonNull(this.font);
        this.addRenderableWidget(new StringWidget(this.x, this.y + 5, this.xSize, 9, (Component)title, Minecraft.getInstance().font));
        this.list = this.addRenderableWidget(new ComponentCreationListWidget(((MachineEditScreen)this.parent).getBuilder(), this.x + 3, this.y + 15, this.xSize - 10, this.ySize - 50));
        this.addRenderableWidget(Button.builder((Component)CONFIRM, b -> this.confirm()).bounds(this.x + 5, this.y + this.ySize - 30, 50, 20).build());
        this.addRenderableWidget(Button.builder((Component)CANCEL, b -> this.cancel()).bounds(this.x + this.xSize - 55, this.y + this.ySize - 30, 50, 20).build());
    }

    protected static class ComponentCreationListWidget
    extends ListWidget<ComponentCreationListEntry> {
        public ComponentCreationListWidget(CustomMachineBuilder builder, int x, int y, int width, int height) {
            super(x, y, width, height, 20, (Component)Component.empty());
            this.setRenderSelection();
            for (MachineComponentType type : Registration.MACHINE_COMPONENT_TYPE_REGISTRY.entrySet().stream().filter(entry -> !((MachineComponentType)entry.getValue()).isSingle() || builder.getComponents().stream().noneMatch(template -> template.getType() == entry.getValue())).sorted(Comparator.comparing(entry -> ((ResourceKey)entry.getKey()).location())).map(Map.Entry::getValue).toList()) {
                IMachineComponentBuilder componentBuilder = MachineComponentBuilderRegistry.getBuilder(type);
                if (componentBuilder == null) continue;
                this.addEntry(new ComponentCreationListEntry(componentBuilder));
            }
            this.setSelected(this.getEntries().isEmpty() ? null : (ComponentCreationListEntry)this.getEntries().get(0));
        }

        protected static class ComponentCreationListEntry
        extends ListWidget.Entry {
            private final IMachineComponentBuilder<?, ?> builder;

            private ComponentCreationListEntry(IMachineComponentBuilder<?, ?> builder) {
                this.builder = builder;
            }

            @Override
            public void render(GuiGraphics graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
                graphics.drawString(Minecraft.getInstance().font, this.builder.type().getTranslatedName(), x + 5, y + 5, 0, false);
            }

            public List<? extends GuiEventListener> children() {
                return Collections.emptyList();
            }
        }
    }
}

