/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.popup;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.MachineConfigScreen;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.config.AutoIOModeButton;
import fr.frinn.custommachinery.client.screen.widget.config.SideModeButton;
import fr.frinn.custommachinery.common.network.CAllSidesNonePacket;
import fr.frinn.custommachinery.common.network.CChangeSideModePacket;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class ComponentConfigPopup
extends PopupScreen {
    private static final WidgetSprites ALL_NONE_SPRITES = new WidgetSprites(CustomMachinery.rl("config/all_none_button"), CustomMachinery.rl("config/all_none_button_hovered"));
    private static final WidgetSprites EXIT_SPRITES = new WidgetSprites(CustomMachinery.rl("config/exit_button"), CustomMachinery.rl("config/exit_button_hovered"));
    private static final Component TITLE = Component.translatable((String)"custommachinery.gui.config.component");
    private final SideConfig<?> config;

    public ComponentConfigPopup(MachineConfigScreen parent, SideConfig<?> config) {
        super(parent, 96, 96);
        this.config = config;
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget(new SideModeButton(this.x + 41, this.y + 25, () -> this.config.getSideMode(RelativeSide.TOP), RelativeSide.TOP, button -> this.setSide(RelativeSide.TOP.ordinal(), true), button -> this.setSide(RelativeSide.TOP.ordinal(), false)));
        this.addRenderableWidget(new SideModeButton(this.x + 25, this.y + 41, () -> this.config.getSideMode(RelativeSide.LEFT), RelativeSide.LEFT, button -> this.setSide(RelativeSide.LEFT.ordinal(), true), button -> this.setSide(RelativeSide.LEFT.ordinal(), false)));
        this.addRenderableWidget(new SideModeButton(this.x + 41, this.y + 41, () -> this.config.getSideMode(RelativeSide.FRONT), RelativeSide.FRONT, button -> this.setSide(RelativeSide.FRONT.ordinal(), true), button -> this.setSide(RelativeSide.FRONT.ordinal(), false)));
        this.addRenderableWidget(new SideModeButton(this.x + 57, this.y + 41, () -> this.config.getSideMode(RelativeSide.RIGHT), RelativeSide.RIGHT, button -> this.setSide(RelativeSide.RIGHT.ordinal(), true), button -> this.setSide(RelativeSide.RIGHT.ordinal(), false)));
        this.addRenderableWidget(new SideModeButton(this.x + 25, this.y + 57, () -> this.config.getSideMode(RelativeSide.BACK), RelativeSide.BACK, button -> this.setSide(RelativeSide.BACK.ordinal(), true), button -> this.setSide(RelativeSide.BACK.ordinal(), false)));
        this.addRenderableWidget(new SideModeButton(this.x + 41, this.y + 57, () -> this.config.getSideMode(RelativeSide.BOTTOM), RelativeSide.BOTTOM, button -> this.setSide(RelativeSide.BOTTOM.ordinal(), true), button -> this.setSide(RelativeSide.BOTTOM.ordinal(), false)));
        SideConfig<?> sideConfig = this.config;
        if (sideConfig instanceof IOSideConfig) {
            IOSideConfig ioSideConfig = (IOSideConfig)sideConfig;
            this.addRenderableWidget(new AutoIOModeButton(this.x + 18, this.y + 75, ioSideConfig::isAutoInput, true, button -> this.setSide(6, true)));
            this.addRenderableWidget(new AutoIOModeButton(this.x + 50, this.y + 75, ioSideConfig::isAutoOutput, false, button -> this.setSide(7, true)));
        }
        ImageButton allNone = this.addRenderableWidget(new ImageButton(this.x + 78, this.y + 57, 14, 14, ALL_NONE_SPRITES, button -> this.setAllNone()));
        allNone.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.config.all_none")));
        ImageButton close = this.addRenderableWidget(new ImageButton(this.x + 5, this.y + 5, 9, 9, EXIT_SPRITES, button -> this.parent.closePopup(this)));
        close.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.config.close")));
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(Minecraft.getInstance().font, TITLE, (int)((float)this.x + (float)this.xSize / 2.0f - (float)this.font.width((FormattedText)TITLE) / 2.0f), this.y + 5, 0, false);
    }

    private void setSide(int side, boolean next) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new CChangeSideModePacket(Minecraft.getInstance().player.containerMenu.containerId, this.getComponentId(), (byte)side, next), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void setAllNone() {
        if (Minecraft.getInstance().player != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CAllSidesNonePacket(Minecraft.getInstance().player.containerMenu.containerId, this.getComponentId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private String getComponentId() {
        return this.config.getComponent().getType().getId().toString() + ":" + this.config.getComponent().getId();
    }
}

