/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget.config;

import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.screen.popup.ComponentConfigPopup;
import fr.frinn.custommachinery.common.util.Color;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class ComponentConfigButton
extends Button {
    private final Color color;
    private final ComponentConfigPopup popup;

    public ComponentConfigButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Color color, ComponentConfigPopup popup) {
        super(x, y, width, height, message, onPress, Supplier::get);
        this.color = color.getAlpha() == 0 ? Color.fromColors(127, color.getRed(), color.getGreen(), color.getBlue()) : color;
        this.popup = popup;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, this.color.getARGB());
        if (this.popup.parent.popups().getFirst() == this.popup) {
            int offset = (int)(System.currentTimeMillis() / 100L % 100L);
            ClientHandler.drawDottedRect(graphics, this.getX() - 1, this.getY() - 1, this.width + 1, this.height + 1, this.color.mul(0.5).getARGB(), 4, 2, offset);
        }
    }
}

