/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.IntegerSyncable;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class FuelMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ITickableComponent,
ISyncableStuff {
    private int fuel;
    private int maxFuel;

    public FuelMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.NONE);
    }

    public MachineComponentType<FuelMachineComponent> getType() {
        return Registration.FUEL_MACHINE_COMPONENT.get();
    }

    @Override
    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putInt("fuel", this.fuel);
        nbt.putInt("maxFuel", this.maxFuel);
    }

    @Override
    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("fuel", 3)) {
            this.fuel = nbt.getInt("fuel");
        }
        if (nbt.contains("maxFuel", 3)) {
            this.maxFuel = nbt.getInt("maxFuel");
        }
    }

    @Override
    public void serverTick() {
        if (this.fuel > 0 && this.getManager().getTile().getStatus() != MachineStatus.RUNNING) {
            --this.fuel;
            this.getManager().markDirty();
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(IntegerSyncable.create(() -> this.fuel, fuel -> {
            this.fuel = fuel;
        }));
        container.accept(IntegerSyncable.create(() -> this.maxFuel, maxFuel -> {
            this.maxFuel = maxFuel;
        }));
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public void addFuel(int fuel) {
        this.fuel += fuel;
        this.maxFuel = fuel;
        this.getManager().markDirty();
    }

    public boolean burn(int amount) {
        if (this.fuel >= amount) {
            this.fuel -= amount;
            this.getManager().markDirty();
            return true;
        }
        this.tryBurnItem();
        if (this.fuel >= amount) {
            this.fuel -= amount;
            this.getManager().markDirty();
            return true;
        }
        return false;
    }

    public boolean canStartRecipe(int amount) {
        if (this.fuel >= amount) {
            return true;
        }
        return this.getManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponents().stream().filter(component -> component.getType() == Registration.ITEM_FUEL_MACHINE_COMPONENT.get() && component.getItemStack().getBurnTime(RecipeType.SMELTING) > 0).findFirst()).isPresent();
    }

    private void tryBurnItem() {
        this.getManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponents().stream().filter(component -> component.getType() == Registration.ITEM_FUEL_MACHINE_COMPONENT.get() && !component.getItemStack().isEmpty()).findFirst()).ifPresent(component -> {
            int fuel = component.getItemStack().getBurnTime(RecipeType.SMELTING);
            this.addFuel(fuel);
            ItemStack stack = component.getItemStack();
            if (stack.hasCraftingRemainingItem()) {
                component.setItemStack(stack.getCraftingRemainingItem());
            } else {
                component.extractItemBypassLimit(1, false);
            }
        });
    }
}

