/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.craft;

import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.common.crafting.CraftingContext;
import fr.frinn.custommachinery.common.crafting.RecipeChecker;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Comparators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;

public class CraftRecipeFinder {
    private final MachineTile tile;
    private final int baseCooldown;
    private List<RecipeChecker<CustomCraftRecipe>> recipes;
    private List<RecipeChecker<CustomCraftRecipe>> okToCheck;
    private boolean inventoryChanged = true;
    private int recipeCheckCooldown;

    public CraftRecipeFinder(MachineTile tile, int baseCooldown) {
        this.tile = tile;
        this.baseCooldown = baseCooldown;
    }

    public void init() {
        if (this.tile.getLevel() == null) {
            throw new IllegalStateException("Broken machine " + String.valueOf(this.tile.getMachine().getId()) + "doesn't have a world");
        }
        this.recipes = this.tile.getLevel().getRecipeManager().getAllRecipesFor((RecipeType)Registration.CUSTOM_CRAFT_RECIPE.get()).stream().filter(recipe -> this.tile.getMachine().getRecipeIds().contains(((CustomCraftRecipe)recipe.value()).getMachineId())).sorted((holder1, holder2) -> Comparators.RECIPE_PRIORITY_COMPARATOR.reversed().compare((IMachineRecipe)holder1.value(), (IMachineRecipe)holder2.value())).map(RecipeChecker::new).toList();
        this.okToCheck = new ArrayList<RecipeChecker<CustomCraftRecipe>>();
        this.recipeCheckCooldown = this.tile.getLevel().random.nextInt(this.baseCooldown);
    }

    public Optional<RecipeHolder<CustomCraftRecipe>> findRecipe(CraftingContext.Mutable context, boolean immediately) {
        if (this.tile.getLevel() == null) {
            return Optional.empty();
        }
        if (immediately || this.recipeCheckCooldown-- <= 0) {
            this.recipeCheckCooldown = this.baseCooldown;
            if (this.inventoryChanged) {
                this.okToCheck.clear();
                this.okToCheck.addAll(this.recipes);
            }
            Iterator<RecipeChecker<CustomCraftRecipe>> iterator = this.okToCheck.iterator();
            while (iterator.hasNext()) {
                RecipeChecker<CustomCraftRecipe> checker = iterator.next();
                if (!this.inventoryChanged && checker.isInventoryRequirementsOnly()) continue;
                if (checker.check(this.tile, context.setRecipe((IMachineRecipe)checker.getRecipe().value(), checker.getRecipe().id()), this.inventoryChanged)) {
                    this.setInventoryChanged(false);
                    return Optional.of(checker.getRecipe());
                }
                if (checker.isInventoryRequirementsOk()) continue;
                iterator.remove();
            }
            this.setInventoryChanged(false);
        }
        return Optional.empty();
    }

    public void setInventoryChanged(boolean changed) {
        this.inventoryChanged = changed;
    }
}

