/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.component.LightMachineComponent;
import fr.frinn.custommachinery.common.component.MachineComponentManager;
import fr.frinn.custommachinery.common.component.RedstoneMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.component.item.ItemMachineComponent;
import fr.frinn.custommachinery.common.init.ConfigurationCardItem;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.network.SRefreshCustomMachineTilePacket;
import fr.frinn.custommachinery.common.util.MachineBlockState;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class CustomMachineBlock
extends Block
implements EntityBlock {
    private static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> spawnPredicate = (state, level, pos, type) -> {
        CustomMachineBlock machineBlock;
        Block patt0$temp;
        return state.isFaceSturdy(level, pos, Direction.UP) && (patt0$temp = state.getBlock()) instanceof CustomMachineBlock && (machineBlock = (CustomMachineBlock)patt0$temp).getLightEmission(state, level, pos) < 14;
    };

    public static BlockBehaviour.Properties makeProperties(boolean occlusion) {
        if (occlusion) {
            return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).requiresCorrectToolForDrops().strength(3.5f).forceSolidOn().dynamicShape().isValidSpawn(spawnPredicate);
        }
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).requiresCorrectToolForDrops().strength(3.5f).forceSolidOn().noOcclusion().dynamicShape().isValidSpawn(spawnPredicate);
    }

    public CustomMachineBlock(boolean occlusion) {
        super(CustomMachineBlock.makeProperties(occlusion));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile machine = (CustomMachineTile)tile;
            if (player.getItemInHand(hand).is((Item)Registration.CONFIGURATION_CARD_ITEM.get())) {
                return ConfigurationCardItem.pasteConfiguration(level, player, machine, player.getItemInHand(hand));
            }
            if (machine.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).map(h -> (FluidComponentHandler)h).map(fluidHandler -> FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)fluidHandler.interactionFluidHandler)).orElse(false).booleanValue()) {
                return ItemInteractionResult.SUCCESS;
            }
            if (!machine.getGuiElements().isEmpty()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CustomMachineContainer.open(serverPlayer, machine);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CustomMachineItem.getMachine(stack).ifPresent(machine -> {
            BlockEntity tile = level.getBlockEntity(pos);
            if (tile instanceof CustomMachineTile) {
                CompoundTag inventory;
                CustomMachineTile machineTile = (CustomMachineTile)tile;
                machineTile.setId(machine.getId());
                if (placer != null) {
                    machineTile.setOwner(placer);
                }
                if ((inventory = (CompoundTag)stack.get(Registration.MACHINE_INVENTORY_DATA)) != null) {
                    CompoundTag components = new CompoundTag();
                    components.put("componentManager", (Tag)inventory);
                    machineTile.loadAdditional(components, (HolderLookup.Provider)level.registryAccess());
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (placer != null && placer.getItemInHand(InteractionHand.OFF_HAND) == stack) {
                        level.getServer().tell((Runnable)new TickTask(1, () -> PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SRefreshCustomMachineTilePacket(pos, machine.getId()), (CustomPacketPayload[])new CustomPacketPayload[0])));
                    }
                }
            }
        });
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        ResourceLocation id = (ResourceLocation)CustomMachinery.CUSTOM_BLOCK_MACHINES.inverse().get((Object)this);
        if (id != null && (blockEntity = level.getBlockEntity(pos)) instanceof CustomMachineTile) {
            CustomMachineTile machineTile = (CustomMachineTile)blockEntity;
            machineTile.refreshMachine(id);
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        CustomMachineTile machine;
        if (blockEntity instanceof CustomMachineTile && player.hasCorrectToolForDrops((BlockState)MachineBlockState.CACHE.getUnchecked((Object)(machine = (CustomMachineTile)blockEntity).getAppearance()), level, pos)) {
            super.playerDestroy(level, player, pos, state, blockEntity, tool);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock()) && level instanceof ServerLevel) {
            CustomMachineTile machine;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CustomMachineTile && !(machine = (CustomMachineTile)blockEntity).getAppearance().shouldKeepInventory()) {
                machine.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).map(handler -> handler.getComponents().stream().filter(ItemMachineComponent::shouldDrop).map(component -> component.getItemStack().copy()).filter(stack -> !stack.isEmpty()).toList()).orElse(Collections.emptyList()).forEach(stack -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack));
                machine.getComponentManager().getComponent(Registration.EXPERIENCE_MACHINE_COMPONENT.get()).filter(component -> component.getXp() > 0).ifPresent(component -> ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)Vec3.atCenterOf((Vec3i)pos), (int)component.getXp()));
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CustomMachineTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return Utils.createTickerHelper(type, Registration.CUSTOM_MACHINE_TILE.get(), CustomMachineTile::clientTick);
        }
        return Utils.createTickerHelper(type, Registration.CUSTOM_MACHINE_TILE.get(), CustomMachineTile::serverTick);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile machine = (CustomMachineTile)tile;
            return machine.getComponentManager().getComponent(Registration.REDSTONE_MACHINE_COMPONENT.get()).map(RedstoneMachineComponent::getComparatorInput).orElse(0);
        }
        return 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile machine = (CustomMachineTile)tile;
            return machine.getComponentManager().getComponent(Registration.REDSTONE_MACHINE_COMPONENT.get()).map(component -> component.getPowerOutput(side.getOpposite())).orElse(0);
        }
        return 0;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile machine = (CustomMachineTile)tile;
            return machine.getComponentManager().getComponent(Registration.REDSTONE_MACHINE_COMPONENT.get()).map(component -> component.getPowerOutput(side.getOpposite())).orElse(0);
        }
        return 0;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return Optional.ofNullable(level.getBlockEntity(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> (CustomMachineTile)tile).map(CustomMachineTile::getAppearance).map(appearance -> Float.valueOf(Utils.getMachineBreakSpeed(appearance, level, pos, player))).orElse(Float.valueOf(super.getDestroyProgress(state, player, level, pos))).floatValue();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Optional.ofNullable(level.getBlockEntity(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> ((CustomMachineTile)tile).getAppearance().getCollisionShape().apply((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))).orElse(super.getCollisionShape(state, level, pos, context));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Optional.ofNullable(level.getBlockEntity(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> ((CustomMachineTile)tile).getAppearance().getShape().apply((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))).orElse(super.getShape(state, level, pos, context));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader level, BlockPos pos, Player player) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile customMachineTile = (CustomMachineTile)tile;
            CustomMachine machine = customMachineTile.getMachine();
            return CustomMachineItem.makeMachineItem(machine.getId());
        }
        return super.getCloneItemStack(state, result, level, pos, player);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return Optional.ofNullable(level.getBlockEntity(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> Float.valueOf(((CustomMachineTile)tile).getAppearance().getResistance())).orElse(Float.valueOf(super.getExplosionResistance())).floatValue();
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return Optional.ofNullable(level.getBlockEntity(pos)).filter(blockEntity -> blockEntity instanceof CustomMachineTile).map(tile -> ((CustomMachineTile)tile).getAppearance().getInteractionSound()).orElse(super.getSoundType(state));
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getFriction();
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof CustomMachineTile) {
            MachineComponentManager manager = ((CustomMachineTile)tile).getComponentManager();
            return manager.getComponent(Registration.LIGHT_MACHINE_COMPONENT.get()).map(LightMachineComponent::getMachineLight).orElse(0);
        }
        return 0;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return Optional.ofNullable(level.getBlockEntity(pos)).filter(blockEntity -> blockEntity instanceof CustomMachineTile).map(blockEntity -> (CustomMachineTile)blockEntity).map(machine -> super.canHarvestBlock((BlockState)MachineBlockState.CACHE.getUnchecked((Object)machine.getAppearance()), level, pos, player)).orElse(super.canHarvestBlock(state, level, pos, player));
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public boolean shouldCheckWeakPower(BlockState blockState, SignalGetter levelReader, BlockPos blockPos, Direction direction) {
        return true;
    }
}

