/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.common.requirement.LightRequirement;
import fr.frinn.custommachinery.impl.util.IntRange;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Light")
public interface LightRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T requireSkyLight(int level) {
        return this.requireSkyLight("" + level);
    }

    @ZenCodeType.Method
    default public T requireSkyLight(String level) {
        try {
            return this.addRequirement(new LightRequirement(IntRange.createFromString(level), true));
        }
        catch (IllegalArgumentException e) {
            return this.error("Invalid light level range: {}, {}", level, e.getMessage());
        }
    }

    @ZenCodeType.Method
    default public T requireBlockLight(int level) {
        return this.requireBlockLight("" + level);
    }

    @ZenCodeType.Method
    default public T requireBlockLight(String level) {
        try {
            return this.addRequirement(new LightRequirement(IntRange.createFromString(level), false));
        }
        catch (IllegalArgumentException e) {
            return this.error("Invalid light level range: {}, {}", level, e.getMessage());
        }
    }
}

