/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.theoneprobe;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.util.MachineBlockState;
import java.util.List;
import java.util.function.Function;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TOPInfoProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    private static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"theoneprobe", (String)"textures/gui/icons.png");

    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        probe.registerProbeConfigProvider(new IProbeConfigProvider(this){

            public void getProbeConfig(IProbeConfig config, Player player, Level world, Entity entity, IProbeHitEntityData data) {
            }

            public void getProbeConfig(IProbeConfig config, Player player, Level world, BlockState state, IProbeHitData data) {
                if (state.getBlock() instanceof CustomMachineBlock) {
                    config.setRFMode(1);
                    config.setTankMode(1);
                    config.showTankSetting(IProbeConfig.ConfigMode.NORMAL);
                    config.showChestContents(IProbeConfig.ConfigMode.NORMAL);
                    config.showCanBeHarvested(IProbeConfig.ConfigMode.NOT);
                    config.showHarvestLevel(IProbeConfig.ConfigMode.NOT);
                }
            }
        });
        return null;
    }

    public ResourceLocation getID() {
        return CustomMachinery.rl("machine_info_provider");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level world, BlockState state, IProbeHitData data) {
        BlockEntity tile = world.getBlockEntity(data.getPos());
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile machine = (CustomMachineTile)tile;
            if (machine.getOwnerName() != null) {
                info.text(CompoundText.create().label((Component)Component.translatable((String)"custommachinery.machine.info.owner", (Object[])new Object[]{machine.getOwnerName()})));
            }
            MachineAppearance appearance = machine.getAppearance();
            TOPInfoProvider.showHarvestInfo(info, appearance, player.hasCorrectToolForDrops((BlockState)MachineBlockState.CACHE.getUnchecked((Object)appearance), world, data.getPos()));
            this.showCraftingManagerInfo(machine, info);
        }
    }

    private void showCraftingManagerInfo(CustomMachineTile tile, IProbeInfo info) {
        MutableComponent status = tile.getStatus().getTranslatedName();
        switch (tile.getStatus()) {
            case ERRORED: {
                status.withStyle(ChatFormatting.RED);
                break;
            }
            case RUNNING: {
                status.withStyle(ChatFormatting.GREEN);
                break;
            }
            case PAUSED: {
                status.withStyle(ChatFormatting.GOLD);
            }
        }
        info.mcText((Component)status);
        IProcessor iProcessor = tile.getProcessor();
        if (iProcessor instanceof MachineProcessor) {
            MachineProcessor machineProcessor = (MachineProcessor)iProcessor;
            machineProcessor.getCores().forEach(core -> {
                if (core.getCurrentRecipe() != null) {
                    info.progress((int)core.getRecipeProgressTime(), ((CustomMachineRecipe)core.getCurrentRecipe().value()).getRecipeTime(), info.defaultProgressStyle().suffix("/" + ((CustomMachineRecipe)core.getCurrentRecipe().value()).getRecipeTime()));
                }
                if (core.getError() != null) {
                    info.text(core.getError());
                }
            });
        }
    }

    private static void showHarvestInfo(IProbeInfo probeInfo, MachineAppearance appearance, boolean harvestable) {
        List<String> tools = appearance.getTool().stream().map(TagKey::location).map(TOPInfoProvider::getTool).toList();
        String level = (String)Config.getHarvestabilityTags().get(appearance.getMiningLevel().location());
        boolean v = true;
        int offs = v ? 16 : 0;
        int dim = v ? 13 : 16;
        ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
        IProbeInfo horizontal = probeInfo.horizontal(alignment);
        if (harvestable) {
            horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text(CompoundText.create().style(TextStyleClass.OK).text(TOPInfoProvider.getToolText(tools)));
        } else if (level.isEmpty()) {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(CompoundText.create().style(TextStyleClass.WARNING).text(TOPInfoProvider.getToolText(tools)));
        } else {
            IProbeInfo icon = horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle);
            CompoundText style = CompoundText.create().style(TextStyleClass.WARNING);
            icon.text(style.text(TOPInfoProvider.getToolText(tools) + " (level " + level + ")"));
        }
    }

    private static String getTool(ResourceLocation tool) {
        if (Config.getTooltypeTags().containsKey(tool)) {
            return (String)Config.getTooltypeTags().get(tool);
        }
        if (tool.getPath().equals("hand")) {
            return "Hand";
        }
        return tool.toString();
    }

    private static String getToolText(List<String> tools) {
        if (tools.isEmpty()) {
            return "No tool";
        }
        if (tools.size() == 1) {
            return tools.get(0);
        }
        return tools.toString();
    }
}

