/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.network.SUpdateMachinesPacket;
import fr.frinn.custommachinery.common.network.SUpdateUpgradesPacket;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.upgrade.UpgradeLocation;
import fr.frinn.custommachinery.common.util.MachineJsonOps;
import fr.frinn.custommachinery.common.util.MachineList;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.minecraft.Util;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FileUtils {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public static void writeNewMachineJson(MinecraftServer server, CustomMachine machine, boolean kubejs) {
        if (kubejs && !ModList.get().isLoaded("kubejs")) {
            CustomMachinery.LOGGER.error("Can't write new machine json {} in kubejs data folder because KubeJS isn't present", (Object)machine.getId());
            return;
        }
        DataResult result = CustomMachine.CODEC.encodeStart(JsonOps.INSTANCE, machine);
        if (result.error().isPresent()) {
            CustomMachinery.LOGGER.error("Can't write new machine json: {}\n{}", (Object)machine.getId().getPath(), (Object)((DataResult.Error)result.error().get()).message());
            return;
        }
        if (result.result().isPresent()) {
            File file;
            File directory;
            JsonElement json = (JsonElement)result.result().get();
            Object root = server.getServerDirectory().toFile().getAbsolutePath();
            if (!FMLLoader.isProduction()) {
                root = ((String)root).substring(0, ((String)root).length() - 2);
            }
            if (kubejs) {
                root = (String)root + File.separator + "kubejs" + File.separator + "data" + File.separator + machine.getId().getNamespace() + File.separator + "machine";
            }
            if (!(directory = (file = new File((String)root, machine.getId().getPath() + ".json")).getParentFile()).exists() && !directory.mkdirs()) {
                CustomMachinery.LOGGER.error("Can't create new directory in '{}'", (Object)directory.getAbsolutePath());
                return;
            }
            CustomMachinery.LOGGER.info("Writing new machine: {} in {}", (Object)machine.getLocation().id(), (Object)file.getPath());
            try {
                if (file.exists() || file.createNewFile()) {
                    JsonWriter writer = GSON.newJsonWriter((Writer)new FileWriter(file));
                    GSON.toJson(json, writer);
                    writer.close();
                    if (kubejs) {
                        CustomMachinery.MACHINES.put(machine.getId(), machine);
                        MachineList.setNeedRefresh();
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SUpdateMachinesPacket(CustomMachinery.MACHINES), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else {
                    CustomMachinery.LOGGER.error("Can't write new machine file in '{}'", (Object)file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                CustomMachinery.LOGGER.error("Error while writing new machine to file: {}\n{}\n{}", (Object)file.getAbsolutePath(), (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public static void writeMachineJson(MinecraftServer server, CustomMachine machine) {
        MachineLocation location = machine.getLocation();
        File machineJson = location.getFile(server);
        if (machineJson == null) {
            CustomMachinery.LOGGER.error("Error while editing machine: {}\nCan't edit machine loaded with {}", (Object)location.id(), (Object)location.loader().toString());
            return;
        }
        if (!machineJson.exists() || machineJson.isDirectory()) {
            CustomMachinery.LOGGER.error("Error while editing machine: {}\nFile '{}' doesn't exist", (Object)location.id(), (Object)machineJson.getAbsolutePath());
            return;
        }
        try (JsonWriter writer = GSON.newJsonWriter((Writer)new FileWriter(machineJson));){
            DataResult result = CustomMachine.CODEC.encodeStart(MachineJsonOps.INSTANCE, machine);
            if (result.error().isPresent()) {
                CustomMachinery.LOGGER.error("Can't edit machine json: {}\n{}", (Object)machine.getId().getPath(), (Object)((DataResult.Error)result.error().get()).message());
                return;
            }
            if (result.result().isPresent()) {
                JsonElement json = (JsonElement)result.result().get();
                GSON.toJson(json, writer);
                BasicFileAttributes attributes = Files.getFileAttributeView(machineJson.toPath(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
                machine.setLocation(MachineLocation.fromLoader(machine.getLocation().loader(), machine.getId(), machine.getLocation().packName(), attributes.creationTime(), attributes.lastModifiedTime()));
                CustomMachinery.LOGGER.info("Successfully edited machine: {} at location '{}'", (Object)location.id(), (Object)machineJson.getAbsolutePath());
            }
        }
        catch (IOException e) {
            CustomMachinery.LOGGER.error("Error while editing machine to file: {}\n{}\n{}", (Object)machineJson.getAbsolutePath(), (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static boolean deleteMachineJson(MinecraftServer server, MachineLocation location) {
        File machineJson = location.getFile(server);
        if (machineJson == null) {
            CustomMachinery.LOGGER.error("Error while deleting machine: {}\nCan't delete machine loaded with {}", (Object)location.id(), (Object)location.loader().toString());
            return false;
        }
        if (!machineJson.exists() || machineJson.isDirectory()) {
            CustomMachinery.LOGGER.error("Error while deleting machine: {}\nFile '{}' doesn't exist", (Object)location.id(), (Object)machineJson.getAbsolutePath());
            return false;
        }
        if (!machineJson.delete()) {
            CustomMachinery.LOGGER.error("Error while deleting machine: {}\nFile '{}' can't be deleted", (Object)location.id(), (Object)machineJson.getAbsolutePath());
            return false;
        }
        CustomMachinery.LOGGER.info("Successfully deleted machine: {} at location '{}'", (Object)location.id(), (Object)machineJson.getAbsolutePath());
        return true;
    }

    public static void writeTempMachineJson(File gameDirectory, CustomMachineBuilder builder) {
        String id = builder.getLocation().id().toString().replace(":", "_").replace("/", "_");
        File temp = Path.of(gameDirectory.toURI()).resolve(".temp custommachinery " + id + " " + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(Calendar.getInstance().getTime()) + ".json").toFile();
        try (JsonWriter writer = GSON.newJsonWriter((Writer)new FileWriter(temp));){
            if (temp.exists() || temp.createNewFile()) {
                DataResult result;
                if (Util.getPlatform() == Util.OS.WINDOWS) {
                    Files.setAttribute(temp.toPath(), "dos:hidden", true, new LinkOption[0]);
                }
                if ((result = CustomMachine.CODEC.encodeStart(MachineJsonOps.INSTANCE, builder.build())).error().isPresent()) {
                    CustomMachinery.LOGGER.error("Can't write temp machine json: {}\n{}", (Object)builder.getLocation().id().getPath(), (Object)((DataResult.Error)result.error().get()).message());
                    return;
                }
                if (result.result().isPresent()) {
                    JsonElement json = (JsonElement)result.result().get();
                    GSON.toJson(json, writer);
                    CustomMachinery.LOGGER.info("Writing temp machine: {} at location '{}'", (Object)builder.getLocation().id(), (Object)temp.getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            CustomMachinery.LOGGER.error("Error while writing temp machine to file: {}\n{}\n{}", (Object)temp.getAbsolutePath(), (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static void writeNewUpgradeJson(MinecraftServer server, UpgradeLocation location, MachineUpgrade upgrade, boolean kubejs) {
        if (kubejs && !ModList.get().isLoaded("kubejs")) {
            CustomMachinery.LOGGER.error("Can't write new upgrade json {} in kubejs data folder because KubeJS isn't present", (Object)location.id());
            return;
        }
        DataResult result = MachineUpgrade.CODEC.encodeStart(JsonOps.INSTANCE, upgrade);
        if (result.error().isPresent()) {
            CustomMachinery.LOGGER.error("Can't write new upgrade json: {}\n{}", (Object)location.id().getPath(), (Object)((DataResult.Error)result.error().get()).message());
            return;
        }
        if (result.result().isPresent()) {
            File file;
            File directory;
            JsonElement json = (JsonElement)result.result().get();
            Object root = server.getServerDirectory().toFile().getAbsolutePath();
            if (!FMLLoader.isProduction()) {
                root = ((String)root).substring(0, ((String)root).length() - 2);
            }
            if (kubejs) {
                root = (String)root + File.separator + "kubejs" + File.separator + "data" + File.separator + location.id().getNamespace() + File.separator + "upgrade";
            }
            if (!(directory = (file = new File((String)root, location.id().getPath() + ".json")).getParentFile()).exists() && !directory.mkdirs()) {
                CustomMachinery.LOGGER.error("Can't create new directory for upgrade in '{}'", (Object)directory.getAbsolutePath());
                return;
            }
            CustomMachinery.LOGGER.info("Writing new upgrade: {} in {}", (Object)location.id(), (Object)file.getPath());
            try {
                if (file.exists() || file.createNewFile()) {
                    JsonWriter writer = GSON.newJsonWriter((Writer)new FileWriter(file));
                    GSON.toJson(json, writer);
                    writer.close();
                    if (kubejs) {
                        CustomMachinery.UPGRADES.addUpgrade(location, upgrade);
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SUpdateUpgradesPacket(CustomMachinery.UPGRADES.getAllUpgrades()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else {
                    CustomMachinery.LOGGER.error("Can't write new upgrade file in '{}'", (Object)file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                CustomMachinery.LOGGER.error("Error while writing new upgrade to file: {}\n{}\n{}", (Object)file.getAbsolutePath(), (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public static void writeUpgradeJson(MinecraftServer server, UpgradeLocation location, MachineUpgrade upgrade) {
        File upgradeJson = location.getFile(server);
        if (upgradeJson == null) {
            CustomMachinery.LOGGER.error("Error while editing upgrade: {}\nCan't edit upgrade loaded with {}", (Object)location.id(), (Object)location.loader().toString());
            return;
        }
        if (!upgradeJson.exists() || upgradeJson.isDirectory()) {
            CustomMachinery.LOGGER.error("Error while editing upgrade: {}\nFile '{}' doesn't exist", (Object)location.id(), (Object)upgradeJson.getAbsolutePath());
            return;
        }
        try (JsonWriter writer = GSON.newJsonWriter((Writer)new FileWriter(upgradeJson));){
            DataResult result = MachineUpgrade.CODEC.encodeStart(MachineJsonOps.INSTANCE, upgrade);
            if (result.error().isPresent()) {
                CustomMachinery.LOGGER.error("Can't edit upgrade json: {}\n{}", (Object)location.id().getPath(), (Object)((DataResult.Error)result.error().get()).message());
                return;
            }
            if (result.result().isPresent()) {
                JsonElement json = (JsonElement)result.result().get();
                GSON.toJson(json, writer);
                CustomMachinery.LOGGER.info("Successfully edited upgrade: {} at location '{}'", (Object)location.id(), (Object)upgradeJson.getAbsolutePath());
            }
        }
        catch (IOException e) {
            CustomMachinery.LOGGER.error("Error while editing upgrade to file: {}\n{}\n{}", (Object)upgradeJson.getAbsolutePath(), (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static boolean deleteUpgradeJson(MinecraftServer server, UpgradeLocation location) {
        File upgradeJson = location.getFile(server);
        if (upgradeJson == null) {
            CustomMachinery.LOGGER.error("Error while deleting upgrade: {}\nCan't delete machine loaded with {}", (Object)location.id(), (Object)location.loader().toString());
            return false;
        }
        if (!upgradeJson.exists() || upgradeJson.isDirectory()) {
            CustomMachinery.LOGGER.error("Error while deleting upgrade: {}\nFile '{}' doesn't exist", (Object)location.id(), (Object)upgradeJson.getAbsolutePath());
            return false;
        }
        if (!upgradeJson.delete()) {
            CustomMachinery.LOGGER.error("Error while deleting upgrade: {}\nFile '{}' can't be deleted", (Object)location.id(), (Object)upgradeJson.getAbsolutePath());
            return false;
        }
        CustomMachinery.LOGGER.info("Successfully deleted upgrade: {} at location '{}'", (Object)location.id(), (Object)upgradeJson.getAbsolutePath());
        return true;
    }
}

